/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.legacy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.graylog.events.event.EventDto;
import org.graylog.events.legacy.LegacyAlarmCallbackEventNotificationConfig;
import org.graylog.events.legacy.LegacyAlarmCallbackFactory;
import org.graylog.events.legacy.LegacyAlertCondition;
import org.graylog.events.processor.EventDefinition;
import org.graylog.events.processor.EventProcessorConfig;
import org.graylog2.alerts.AbstractAlertCondition;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.alarms.callbacks.AlarmCallbackConfigurationException;
import org.graylog2.plugin.alarms.callbacks.AlarmCallbackException;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamImpl;
import org.graylog2.streams.StreamService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyAlarmCallbackSender {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyAlarmCallbackSender.class);
    private final LegacyAlarmCallbackFactory alarmCallbackFactory;
    private final StreamService streamService;
    private final ObjectMapper objectMapper;

    @Inject
    public LegacyAlarmCallbackSender(LegacyAlarmCallbackFactory alarmCallbackFactory, StreamService streamService, ObjectMapper objectMapper) {
        this.alarmCallbackFactory = alarmCallbackFactory;
        this.streamService = streamService;
        this.objectMapper = objectMapper;
    }

    public void send(LegacyAlarmCallbackEventNotificationConfig config, EventDefinition eventDefinition, EventDto event, List<MessageSummary> backlog) throws Exception {
        String callbackType = config.callbackType();
        Stream stream = this.findStream(eventDefinition.config());
        LegacyAlertCondition alertCondition = new LegacyAlertCondition(stream, eventDefinition, event);
        AbstractAlertCondition.CheckResult checkResult = new AbstractAlertCondition.CheckResult(true, alertCondition, event.message(), event.processingTimestamp(), backlog);
        try {
            AlarmCallback callback = this.alarmCallbackFactory.create(callbackType, config.configuration());
            callback.checkConfiguration();
            callback.call(stream, checkResult);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Couldn't find implementation class for type <{}>", (Object)callbackType);
            throw e;
        }
        catch (AlarmCallbackConfigurationException e) {
            LOG.error("Invalid legacy alarm callback configuration", (Throwable)e);
            throw e;
        }
        catch (ConfigurationException e) {
            LOG.error("Invalid configuration for legacy alarm callback <{}>", (Object)callbackType, (Object)e);
            throw e;
        }
        catch (AlarmCallbackException e) {
            LOG.error("Couldn't execute legacy alarm callback <{}>", (Object)callbackType, (Object)e);
            throw e;
        }
    }

    private Stream findStream(EventProcessorConfig eventProcessorConfig) {
        JsonNode config = (JsonNode)this.objectMapper.convertValue((Object)eventProcessorConfig, JsonNode.class);
        JsonNode streams = config.path("streams");
        if (streams.isMissingNode() || !streams.isArray()) {
            LOG.debug("Couldn't find streams in event processor config: {}", (Object)eventProcessorConfig);
            return MissingStream.create();
        }
        if (streams.size() > 1) {
            LOG.warn("Found more than one stream in event definition. Please don't use legacy alarm callbacks anymore!");
        }
        String streamId = streams.path(0).asText();
        try {
            return this.streamService.load(streamId);
        }
        catch (NotFoundException e) {
            LOG.error("Couldn't load stream <{}> from database", (Object)streamId, (Object)e);
            return MissingStream.create();
        }
    }

    private static class MissingStream
    extends StreamImpl {
        static Stream create() {
            ImmutableMap fields = ImmutableMap.builder().put((Object)"_id", (Object)new ObjectId("5400deadbeefdeadbeefaffe")).put((Object)"title", (Object)"Missing stream").put((Object)"description", (Object)"We could find a stream").put((Object)"rules", (Object)ImmutableList.of()).put((Object)"outputs", (Object)ImmutableSet.of()).put((Object)"created_at", (Object)DateTime.now((DateTimeZone)DateTimeZone.UTC)).put((Object)"creator_user_id", (Object)"admin").put((Object)"alert_conditions", (Object)ImmutableList.of()).build();
            return new MissingStream((Map<String, Object>)fields);
        }

        private MissingStream(Map<String, Object> fields) {
            super(new ObjectId(), fields, Collections.emptyList(), Collections.emptySet(), null);
        }
    }
}

