/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotBlank;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.graylog.events.configuration.EventsConfigurationProvider;
import org.graylog.events.event.EventDto;
import org.graylog.events.notifications.AutoValue_EventNotificationExecutionJob_Config;
import org.graylog.events.notifications.AutoValue_EventNotificationExecutionJob_Data;
import org.graylog.events.notifications.DBNotificationGracePeriodService;
import org.graylog.events.notifications.DBNotificationService;
import org.graylog.events.notifications.EventNotification;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationException;
import org.graylog.events.notifications.EventNotificationExecutionMetrics;
import org.graylog.events.notifications.NotificationDto;
import org.graylog.events.notifications.PermanentEventNotificationException;
import org.graylog.events.notifications.TemporaryEventNotificationException;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.scheduler.Job;
import org.graylog.scheduler.JobDefinitionConfig;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog.scheduler.JobExecutionContext;
import org.graylog.scheduler.JobExecutionException;
import org.graylog.scheduler.JobTriggerData;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.JobTriggerUpdate;
import org.graylog2.database.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventNotificationExecutionJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(EventNotificationExecutionJob.class);
    public static final String TYPE_NAME = "notification-execution-v1";
    private final Config jobConfig;
    private final DBNotificationService notificationService;
    private final DBEventDefinitionService eventDefinitionService;
    private final DBNotificationGracePeriodService notificationGracePeriodService;
    private final Map<String, EventNotification.Factory> eventNotificationFactories;
    private final EventsConfigurationProvider configurationProvider;
    private final EventNotificationExecutionMetrics metrics;

    @Inject
    public EventNotificationExecutionJob(@Assisted JobDefinitionDto jobDefinition, DBNotificationService dbNotificationService, DBEventDefinitionService eventDefinitionService, DBNotificationGracePeriodService notificationGracePeriodService, Map<String, EventNotification.Factory> eventNotificationFactories, EventsConfigurationProvider configurationProvider, EventNotificationExecutionMetrics metrics) {
        this.jobConfig = (Config)jobDefinition.config();
        this.notificationService = dbNotificationService;
        this.eventDefinitionService = eventDefinitionService;
        this.notificationGracePeriodService = notificationGracePeriodService;
        this.eventNotificationFactories = eventNotificationFactories;
        this.configurationProvider = configurationProvider;
        this.metrics = metrics;
    }

    @Override
    public JobTriggerUpdate execute(JobExecutionContext ctx) throws JobExecutionException {
        Optional<EventDefinitionDto> optionalEventDefinition;
        long gracePeriodInMS = 0L;
        JobTriggerDto trigger = ctx.trigger();
        Optional<Data> optionalData = trigger.data().map(d -> (Data)d);
        if (!optionalData.isPresent()) {
            throw new JobExecutionException("Missing notification job data for notification <" + this.jobConfig.notificationId() + ">, unable to execute notification: " + ctx.definition().title(), trigger, JobTriggerUpdate.withoutNextTime());
        }
        Data data = optionalData.get();
        EventDto eventDto = data.eventDto();
        NotificationDto notification = (NotificationDto)this.notificationService.get(this.jobConfig.notificationId()).orElseThrow(() -> new JobExecutionException("Couldn't find notification <" + this.jobConfig.notificationId() + ">", trigger, JobTriggerUpdate.withError(trigger)));
        EventNotification.Factory eventNotificationFactory = this.eventNotificationFactories.get(notification.config().type());
        if (eventNotificationFactory == null) {
            throw new JobExecutionException("Couldn't find factory for notification type <" + notification.config().type() + ">", trigger, ctx.jobTriggerUpdates().scheduleNextExecution());
        }
        Object eventNotification = eventNotificationFactory.create();
        this.metrics.registerEventNotification((EventNotification)eventNotification, notification);
        try {
            optionalEventDefinition = Optional.ofNullable(this.getEventDefinition(eventDto));
            if (optionalEventDefinition.isPresent()) {
                gracePeriodInMS = optionalEventDefinition.get().notificationSettings().gracePeriodMs();
            }
        }
        catch (NotFoundException e) {
            LOG.error("Couldn't find event definition with ID <{}>.", (Object)eventDto.eventDefinitionId());
            optionalEventDefinition = Optional.empty();
        }
        EventNotificationContext notificationContext = EventNotificationContext.builder().notificationId(notification.id()).notificationConfig(notification.config()).event(eventDto).eventDefinition(optionalEventDefinition.get()).jobTrigger(trigger).build();
        this.updateTriggerStatus(eventDto, gracePeriodInMS);
        if (this.inGrace(eventDto, gracePeriodInMS)) {
            LOG.debug("Notification <{}> triggered but it's in grace period.", (Object)this.jobConfig.notificationId());
            this.metrics.markInGrace((EventNotification)eventNotification, notification);
            return ctx.jobTriggerUpdates().scheduleNextExecution();
        }
        try {
            this.metrics.markExecution((EventNotification)eventNotification, notification);
            eventNotification.execute(notificationContext);
            this.metrics.markSuccess((EventNotification)eventNotification, notification);
        }
        catch (TemporaryEventNotificationException e) {
            this.metrics.markFailedTemporarily((EventNotification)eventNotification, notification);
            long retryPeriod = this.configurationProvider.get().eventNotificationsRetry();
            throw new JobExecutionException(String.format(Locale.ROOT, "Failed to execute notification, retrying in %d minutes - <%s/%s/%s>", TimeUnit.MILLISECONDS.toMinutes(retryPeriod), notification.id(), notification.title(), notification.config().type()), trigger, ctx.jobTriggerUpdates().retryIn(retryPeriod, TimeUnit.MILLISECONDS), e);
        }
        catch (PermanentEventNotificationException e) {
            this.metrics.markFailedPermanently((EventNotification)eventNotification, notification);
            throw new JobExecutionException(String.format(Locale.ROOT, "Failed permanently to execute notification, giving up - <%s/%s/%s>", notification.id(), notification.title(), notification.config().type()), trigger, ctx.jobTriggerUpdates().scheduleNextExecution(), e);
        }
        catch (EventNotificationException e) {
            this.metrics.markFailed((EventNotification)eventNotification, notification);
            throw new JobExecutionException(String.format(Locale.ROOT, "Notification failed to execute - <%s/%s/%s>", notification.id(), notification.title(), notification.config().type()), trigger, ctx.jobTriggerUpdates().scheduleNextExecution(), e);
        }
        this.updateNotifiedStatus(eventDto, gracePeriodInMS);
        return ctx.jobTriggerUpdates().scheduleNextExecution();
    }

    private EventDefinitionDto getEventDefinition(EventDto eventDto) throws NotFoundException {
        return this.eventDefinitionService.get(eventDto.eventDefinitionId()).orElseThrow(() -> new NotFoundException("Could not find event definition <" + eventDto.eventDefinitionId() + ">"));
    }

    private void updateTriggerStatus(EventDto eventDto, long gracePeriodInMS) {
        if (eventDto != null) {
            this.notificationGracePeriodService.updateTriggerStatus(this.jobConfig.notificationId(), eventDto, gracePeriodInMS);
        }
    }

    private void updateNotifiedStatus(EventDto eventDto, long gracePeriodInMS) {
        if (eventDto != null) {
            this.notificationGracePeriodService.updateNotifiedStatus(this.jobConfig.notificationId(), eventDto, gracePeriodInMS);
        }
    }

    private boolean inGrace(EventDto eventDto, long gracePeriodInMS) {
        if (gracePeriodInMS == 0L) {
            return false;
        }
        try {
            boolean inGrace = this.notificationGracePeriodService.inGracePeriod(eventDto, this.jobConfig.notificationId(), gracePeriodInMS);
            if (inGrace) {
                return true;
            }
        }
        catch (NotFoundException e) {
            LOG.error("Couldn't find notification with ID <{}>.", (Object)this.jobConfig.notificationId());
        }
        return false;
    }

    @JsonTypeName(value="notification-execution-v1")
    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class Config
    implements JobDefinitionConfig {
        private static final String FIELD_NOTIFICATION_ID = "notification_id";

        @JsonProperty(value="notification_id")
        @NotBlank
        public abstract String notificationId();

        public static Builder builder() {
            return Builder.create();
        }

        public abstract Builder toBuilder();

        @AutoValue.Builder
        public static abstract class Builder
        implements JobDefinitionConfig.Builder<Builder> {
            @JsonCreator
            public static Builder create() {
                return new AutoValue_EventNotificationExecutionJob_Config.Builder().type(EventNotificationExecutionJob.TYPE_NAME);
            }

            @JsonProperty(value="notification_id")
            public abstract Builder notificationId(String var1);

            abstract Config autoBuild();

            public Config build() {
                this.type(EventNotificationExecutionJob.TYPE_NAME);
                return this.autoBuild();
            }
        }
    }

    @JsonTypeName(value="notification-execution-v1")
    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class Data
    implements JobTriggerData {
        private static final String FIELD_EVENT_DTO = "event_dto";

        @JsonProperty(value="event_dto")
        public abstract EventDto eventDto();

        public static Builder builder() {
            return Builder.create();
        }

        public abstract Builder toBuilder();

        @AutoValue.Builder
        public static abstract class Builder
        implements JobTriggerData.Builder<Builder> {
            @JsonCreator
            public static Builder create() {
                return new AutoValue_EventNotificationExecutionJob_Data.Builder().type(EventNotificationExecutionJob.TYPE_NAME);
            }

            @JsonProperty(value="event_dto")
            public abstract Builder eventDto(EventDto var1);

            abstract Data autoBuild();

            public Data build() {
                this.type(EventNotificationExecutionJob.TYPE_NAME);
                return this.autoBuild();
            }
        }
    }

    public static interface Factory
    extends Job.Factory<EventNotificationExecutionJob> {
        @Override
        public EventNotificationExecutionJob create(JobDefinitionDto var1);
    }
}

