/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications.types;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.floreysoft.jmte.Engine;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;
import org.graylog.events.configuration.EventsConfigurationProvider;
import org.graylog.events.notifications.EventNotification;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationModelData;
import org.graylog.events.notifications.EventNotificationService;
import org.graylog.events.notifications.PermanentEventNotificationException;
import org.graylog.events.notifications.TemporaryEventNotificationException;
import org.graylog.events.notifications.types.HTTPEventNotificationConfigV2;
import org.graylog.events.notifications.types.HTTPNotification;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.security.encryption.EncryptedValueService;
import org.graylog2.shared.bindings.providers.ObjectMapperProvider;
import org.graylog2.shared.bindings.providers.ParameterizedHttpClientProvider;
import org.graylog2.system.urlwhitelist.UrlWhitelistNotificationService;
import org.graylog2.system.urlwhitelist.UrlWhitelistService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPEventNotificationV2
extends HTTPNotification
implements EventNotification {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPEventNotificationV2.class);
    private static final String EVENT = "event_";
    private final EventNotificationService notificationCallbackService;
    private final ObjectMapperProvider objectMapperProvider;
    private final EventsConfigurationProvider configurationProvider;
    private final ParameterizedHttpClientProvider parameterizedHttpClientProvider;
    private final Engine templateEngine;
    private final NotificationService notificationService;
    private final NodeId nodeId;

    @Inject
    public HTTPEventNotificationV2(EventNotificationService notificationCallbackService, ObjectMapperProvider objectMapperProvider, UrlWhitelistService whitelistService, UrlWhitelistNotificationService urlWhitelistNotificationService, EncryptedValueService encryptedValueService, EventsConfigurationProvider configurationProvider, Engine templateEngine, NotificationService notificationService, NodeId nodeId, ParameterizedHttpClientProvider parameterizedHttpClientProvider) {
        super(whitelistService, urlWhitelistNotificationService, encryptedValueService);
        this.notificationCallbackService = notificationCallbackService;
        this.objectMapperProvider = objectMapperProvider;
        this.configurationProvider = configurationProvider;
        this.parameterizedHttpClientProvider = parameterizedHttpClientProvider;
        this.templateEngine = templateEngine;
        this.notificationService = notificationService;
        this.nodeId = nodeId;
    }

    private OkHttpClient selectClient(HTTPEventNotificationConfigV2 notificationConfig) {
        boolean withKeepAlive = this.configurationProvider.get().notificationsKeepAliveProbe();
        return this.parameterizedHttpClientProvider.get(withKeepAlive, notificationConfig.skipTLSVerification());
    }

    @Override
    public void execute(EventNotificationContext ctx) throws TemporaryEventNotificationException, PermanentEventNotificationException {
        String body;
        HTTPEventNotificationConfigV2 config = (HTTPEventNotificationConfigV2)ctx.notificationConfig();
        ImmutableList<MessageSummary> backlog = this.notificationCallbackService.getBacklogForEvent(ctx);
        EventNotificationModelData modelData = EventNotificationModelData.of(ctx, backlog);
        HttpUrl httpUrl = this.validateUrl(config.url(), ctx.notificationId(), modelData.eventDefinitionTitle());
        Request.Builder builder = new Request.Builder();
        this.addAuthHeader(builder, config.basicAuth());
        this.addApiKey(builder, httpUrl, config.apiKey(), config.apiSecret(), config.apiKeyAsHeader());
        this.addHeaders(builder, config.headers());
        try {
            body = this.buildRequestBody(modelData, config);
        }
        catch (JsonProcessingException processingErr) {
            String errorMessage = "Unable to serialize notification";
            this.createSystemErrorNotification(errorMessage + "for notification [" + ctx.notificationId() + "]");
            throw new PermanentEventNotificationException(errorMessage, processingErr);
        }
        catch (UnsupportedEncodingException encodingErr) {
            String errorMessage = "Unable to URL encode notification body";
            this.createSystemErrorNotification(errorMessage + "for notification [" + ctx.notificationId() + "]");
            throw new PermanentEventNotificationException(errorMessage, encodingErr);
        }
        switch (config.httpMethod()) {
            case GET: {
                builder.get();
                break;
            }
            case PUT: {
                builder.put(RequestBody.create((String)body, (MediaType)this.getMediaType(config.contentType())));
                break;
            }
            case POST: {
                builder.post(RequestBody.create((String)body, (MediaType)this.getMediaType(config.contentType())));
            }
        }
        LOG.debug("Requesting HTTP endpoint at <{}> in notification <{}>", (Object)config.url(), (Object)ctx.notificationId());
        OkHttpClient httpClient = this.selectClient(config);
        try (Response r = httpClient.newCall(builder.build()).execute();){
            if (!r.isSuccessful()) {
                String errorMessage = "Expected successful HTTP response [2xx] but got [" + r.code() + "]. " + config.url();
                this.createSystemErrorNotification(errorMessage + "for notification [" + ctx.notificationId() + "]");
                throw new PermanentEventNotificationException(errorMessage);
            }
        }
        catch (IOException e) {
            throw new PermanentEventNotificationException(e.getMessage());
        }
    }

    private void createSystemErrorNotification(String message) {
        Notification systemNotification = this.notificationService.buildNow().addNode(this.nodeId.getNodeId()).addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.URGENT).addDetail("title", "Custom HTTP Notification Failed").addDetail("description", message);
        this.notificationService.publishIfFirst(systemNotification);
    }

    private MediaType getMediaType(HTTPEventNotificationConfigV2.ContentType contentType) {
        switch (contentType) {
            case FORM_DATA: {
                return MediaType.parse((String)"application/x-www-form-urlencoded");
            }
            case JSON: {
                return MediaType.parse((String)"application/json");
            }
            case PLAIN_TEXT: {
                return MediaType.parse((String)"text/plain");
            }
        }
        return null;
    }

    private String buildRequestBody(EventNotificationModelData modelData, HTTPEventNotificationConfigV2 config) throws JsonProcessingException, UnsupportedEncodingException {
        String body;
        if (config.httpMethod().equals((Object)HTTPEventNotificationConfigV2.HttpMethod.GET) || config.contentType() == null) {
            return "";
        }
        String bodyTemplate = config.bodyTemplate();
        ObjectMapper objectMapper = this.objectMapperProvider.getForTimeZone(config.timeZone());
        Map modelMap = (Map)objectMapper.convertValue((Object)modelData, TypeReferences.MAP_STRING_OBJECT);
        if (!Strings.isNullOrEmpty((String)bodyTemplate)) {
            if (config.contentType().equals((Object)HTTPEventNotificationConfigV2.ContentType.FORM_DATA)) {
                String[] parts = bodyTemplate.split("&");
                body = Arrays.stream(parts).map(part -> {
                    int equalsIndex = part.indexOf("=");
                    String encodedKey = this.urlEncode(part.substring(0, equalsIndex));
                    String encodedValue = equalsIndex < part.length() - 1 ? this.urlEncode(this.templateEngine.transform(part.substring(equalsIndex + 1), modelMap)) : "";
                    return encodedKey + "=" + encodedValue;
                }).collect(Collectors.joining("&"));
            } else {
                body = this.templateEngine.transform(bodyTemplate, modelMap);
            }
        } else if (config.contentType().equals((Object)HTTPEventNotificationConfigV2.ContentType.FORM_DATA)) {
            Map eventMap = (Map)objectMapper.convertValue((Object)modelData.event(), TypeReferences.MAP_STRING_OBJECT);
            body = this.getUrlEncodedEvent(modelMap, eventMap);
        } else {
            body = objectMapper.writeValueAsString((Object)modelData);
        }
        return body;
    }

    private String getUrlEncodedEvent(Map<String, Object> modelMap, Map<String, Object> eventMap) {
        return StringUtils.chop((String)(this.urlEncodedKeyValue("event_definition_id", modelMap.get("event_definition_id")) + this.urlEncodedKeyValue("event_definition_type", modelMap.get("event_definition_type")) + this.urlEncodedKeyValue("event_definition_title", modelMap.get("event_definition_title")) + this.urlEncodedKeyValue("event_definition_description", modelMap.get("event_definition_description")) + this.urlEncodedKeyValue("job_definition_id", modelMap.get("job_definition_id")) + this.urlEncodedKeyValue("job_trigger_id", modelMap.get("job_trigger_id")) + this.urlEncodedKeyValue("event_id", eventMap.get("id")) + this.urlEncodedKeyValue("event_origin_context", eventMap.get("origin_context")) + this.urlEncodedKeyValue("event_timestamp", eventMap.get("timestamp")) + this.urlEncodedKeyValue("event_timestamp_processing", eventMap.get("timestamp_processing")) + this.urlEncodedKeyValue("event_timerange_start", eventMap.get("timerange_start")) + this.urlEncodedKeyValue("event_timerange_end", eventMap.get("timerange_end")) + this.urlEncodedKeyValue("event_streams", eventMap.get("streams")) + this.urlEncodedKeyValue("event_source_streams", eventMap.get("source_streams")) + this.urlEncodedKeyValue("event_message", eventMap.get("message")) + this.urlEncodedKeyValue("event_source", eventMap.get("source")) + this.urlEncodedKeyValue("event_key_tuple", eventMap.get("key_tuple")) + this.urlEncodedKeyValue("event_key", eventMap.get("key")) + this.urlEncodedKeyValue("event_priority", eventMap.get("priority")) + this.urlEncodedKeyValue("event_fields", eventMap.get("fields")) + this.urlEncodedKeyValue("backlog", modelMap.get("backlog"))));
    }

    private String urlEncodedKeyValue(String key, Object value) {
        return this.urlEncode(key) + "=" + (value != null ? this.urlEncode(value.toString()) : "") + "&";
    }

    private String urlEncode(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
    }

    public static interface Factory
    extends EventNotification.Factory<HTTPEventNotificationV2> {
        @Override
        public HTTPEventNotificationV2 create();
    }
}

