/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.notifications.types.util;

import jakarta.inject.Inject;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.graylog.events.notifications.PermanentEventNotificationException;
import org.graylog.events.notifications.TemporaryEventNotificationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestClient {
    private static final Logger LOG = LoggerFactory.getLogger(RequestClient.class);
    private final OkHttpClient httpClient;

    @Inject
    public RequestClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void send(String message, String webhookUrl) throws TemporaryEventNotificationException, PermanentEventNotificationException {
        Request request = new Request.Builder().url(webhookUrl).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)message)).build();
        LOG.debug("Posting to webhook url <{}> the payload is <{}>", (Object)webhookUrl, (Object)message);
        try (Response r = this.httpClient.newCall(request).execute();){
            if (!r.isSuccessful()) {
                throw new PermanentEventNotificationException("Expected successful HTTP response [2xx] but got [" + r.code() + "]. " + webhookUrl);
            }
        }
        catch (IOException e) {
            throw new TemporaryEventNotificationException("Unable to send the Message. " + e.getMessage());
        }
    }
}

