/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.cef.parser;

import java.util.Locale;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class CEFTimestampParser {
    private static final DateTimeFormatter[] DATE_TIME_FORMATTERS = new DateTimeFormatter[]{ISODateTimeFormat.dateTime(), ISODateTimeFormat.dateTimeNoMillis(), ISODateTimeFormat.basicDateTime(), ISODateTimeFormat.basicDateTimeNoMillis(), DateTimeFormat.forPattern((String)"MMM dd HH:mm:ss.SSS ZZZ"), DateTimeFormat.forPattern((String)"MMM dd HH:mm:sss.SSS"), DateTimeFormat.forPattern((String)"MMM dd HH:mm:ss ZZZ"), DateTimeFormat.forPattern((String)"MMM dd HH:mm:ss"), DateTimeFormat.forPattern((String)"MMM dd yyyy HH:mm:ss.SSS ZZZ"), DateTimeFormat.forPattern((String)"MMM dd yyyy HH:mm:ss.SSS"), DateTimeFormat.forPattern((String)"MMM dd yyyy HH:mm:ss ZZZ"), DateTimeFormat.forPattern((String)"MMM dd yyyy HH:mm:ss"), DateTimeFormat.fullDateTime(), DateTimeFormat.mediumDateTime(), DateTimeFormat.shortDateTime(), DateTimeFormat.longDateTime()};

    @Nullable
    public static DateTime parse(String s, DateTimeZone timeZone, Locale locale) {
        String text = s.trim().replaceAll("\\s{2,}", " ");
        try {
            long l = Long.parseLong(text);
            return new DateTime(l, DateTimeZone.UTC);
        }
        catch (NumberFormatException numberFormatException) {
            for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
                try {
                    return dateTimeFormatter.withZone(timeZone).withLocale(locale).parseDateTime(text);
                }
                catch (Exception exception) {
                }
            }
            return null;
        }
    }

    @Nullable
    public static DateTime parse(String text) {
        return CEFTimestampParser.parse(text, DateTimeZone.UTC, Locale.ROOT);
    }
}

