/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.memory;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.graylog.plugins.pipelineprocessor.db.RuleDao;
import org.graylog.plugins.pipelineprocessor.db.RuleService;
import org.graylog.plugins.pipelineprocessor.events.RulesChangedEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;

public class InMemoryRuleService
implements RuleService {
    private final AtomicLong idGen = new AtomicLong(0L);
    private final Map<String, RuleDao> store = new ConcurrentHashMap<String, RuleDao>();
    private final Map<String, String> titleToId = new ConcurrentHashMap<String, String>();
    private final ClusterEventBus clusterBus;

    @Inject
    public InMemoryRuleService(ClusterEventBus clusterBus) {
        this.clusterBus = clusterBus;
    }

    @Override
    public RuleDao save(RuleDao rule) {
        RuleDao toSave;
        RuleDao ruleDao = toSave = rule.id() != null ? rule : rule.toBuilder().id(this.createId()).build();
        if (this.titleToId.containsKey(toSave.title()) && !this.titleToId.get(toSave.title()).equals(toSave.id())) {
            throw new IllegalArgumentException("Duplicate rule titles are not allowed: " + toSave.title());
        }
        this.titleToId.put(toSave.title(), toSave.id());
        this.store.put(toSave.id(), toSave);
        this.clusterBus.post(RulesChangedEvent.updatedRuleId(toSave.id()));
        return toSave;
    }

    @Override
    public RuleDao load(String id) throws NotFoundException {
        RuleDao rule = this.store.get(id);
        if (rule == null) {
            throw new NotFoundException("No such rule with id " + id);
        }
        return rule;
    }

    @Override
    public RuleDao loadByName(String name) throws NotFoundException {
        String id = this.titleToId.get(name);
        if (id == null) {
            throw new NotFoundException("No rule with name " + name);
        }
        return this.load(id);
    }

    @Override
    public Collection<RuleDao> loadAll() {
        return ImmutableSet.copyOf(this.store.values());
    }

    @Override
    public void delete(String id) {
        if (id == null) {
            return;
        }
        RuleDao removed = this.store.remove(id);
        if (removed != null) {
            this.titleToId.remove(removed.title());
        }
        this.clusterBus.post(RulesChangedEvent.deletedRuleId(id));
    }

    @Override
    public Collection<RuleDao> loadNamed(Collection<String> ruleNames) {
        HashSet needles = Sets.newHashSet(ruleNames);
        return this.store.values().stream().filter(ruleDao -> needles.contains(ruleDao.title())).collect(Collectors.toList());
    }

    private String createId() {
        return String.valueOf(this.idGen.incrementAndGet());
    }
}

