/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.dates;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.dates.TimezoneAwareFunction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ParseUnixMilliseconds
extends TimezoneAwareFunction {
    public static final String NAME = "parse_unix_milliseconds";
    private static final String VALUE = "value";
    private final ParameterDescriptor<Long, Long> valueParam = ParameterDescriptor.integer("value").ruleBuilderVariable().description("UNIX millisecond timestamp to parse").build();

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected ImmutableList<ParameterDescriptor> params() {
        return ImmutableList.of(this.valueParam);
    }

    @Override
    public DateTime evaluate(FunctionArgs args, EvaluationContext context, DateTimeZone timezone) {
        Long unixMillis = this.valueParam.required(args, context);
        return unixMillis == null ? null : new DateTime((Object)unixMillis, timezone);
    }

    @Override
    protected String description() {
        return "Converts a UNIX millisecond timestamp into a date";
    }

    @Override
    @Nonnull
    protected String getRuleBuilderName() {
        return "Parse UNIX timestamp";
    }

    @Override
    @Nonnull
    protected String getRuleBuilderTitle() {
        return "Parse '${value}' timestamp into a DateTime";
    }
}

