/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.syslog;

import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.syslog.SyslogPriority;
import org.graylog.plugins.pipelineprocessor.functions.syslog.SyslogUtils;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class SyslogPriorityConversion
extends AbstractFunction<SyslogPriority> {
    public static final String NAME = "expand_syslog_priority";
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").description("Value to convert").build();

    @Override
    public SyslogPriority evaluate(FunctionArgs args, EvaluationContext context) {
        String s = String.valueOf(this.valueParam.required(args, context));
        int priority = Integer.parseInt(s);
        int facility = SyslogUtils.facilityFromPriority(priority);
        int level = SyslogUtils.levelFromPriority(priority);
        return SyslogPriority.create(level, facility);
    }

    @Override
    public FunctionDescriptor<SyslogPriority> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(SyslogPriority.class).params(this.valueParam).description("Converts a syslog priority number to its level and facility").ruleBuilderEnabled().ruleBuilderName("Convert syslog priority").ruleBuilderTitle("Converts a syslog priority number in '${value}' to level and facility").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.SYSLOG).build();
    }
}

