/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.rulebuilder.AutoValue_RuleBuilder;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderStep;

@AutoValue
public abstract class RuleBuilder {
    protected static final String FIELD_OPERATOR = "operator";
    protected static final String FIELD_CONDITIONS = "conditions";
    protected static final String FIELD_ACTIONS = "actions";
    protected static final String FIELD_ERRORS = "errors";

    @JsonProperty(value="operator")
    @Nullable
    public abstract RuleBuilderStep.Operator operator();

    @JsonProperty(value="conditions")
    @Nullable
    public abstract List<RuleBuilderStep> conditions();

    @JsonProperty(value="actions")
    @Nullable
    public abstract List<RuleBuilderStep> actions();

    @JsonProperty(value="errors")
    @Nullable
    public abstract List<String> errors();

    public static Builder builder() {
        return new AutoValue_RuleBuilder.Builder();
    }

    public abstract Builder toBuilder();

    @JsonCreator
    public static RuleBuilder create(@JsonProperty(value="operator") @Nullable RuleBuilderStep.Operator operator, @JsonProperty(value="conditions") @Nullable List<RuleBuilderStep> conditions, @JsonProperty(value="actions") @Nullable List<RuleBuilderStep> actions, @JsonProperty(value="errors") @Nullable List<String> errors) {
        return RuleBuilder.builder().operator(operator).conditions(conditions).actions(actions).errors(errors).build();
    }

    public RuleBuilder normalize() {
        if (Objects.isNull(this.actions())) {
            return this;
        }
        HashMap<Integer, Integer> varMapping = new HashMap<Integer, Integer>();
        ArrayList<RuleBuilderStep> normalizedOutputs = new ArrayList<RuleBuilderStep>();
        int newIndex = 1;
        for (RuleBuilderStep action : this.actions()) {
            String outputVariable = action.outputvariable();
            int varIndex = action.generatedOutputIndex();
            if (varIndex >= 0) {
                varMapping.put(varIndex, newIndex);
                outputVariable = action.generateOutput(newIndex++);
            }
            normalizedOutputs.add(action.toBuilder().outputvariable(outputVariable).build());
        }
        if (newIndex == 1) {
            return this;
        }
        ArrayList<RuleBuilderStep> normalizedOutputsAndParams = new ArrayList<RuleBuilderStep>();
        for (RuleBuilderStep action : normalizedOutputs) {
            HashMap<String, Object> updatedParams = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : action.parameters().entrySet()) {
                Object object = entry.getValue();
                if (object instanceof String) {
                    String valueString = (String)object;
                    int paramIndex = action.generatedParameterIndex(valueString);
                    if (paramIndex > 0) {
                        updatedParams.put(entry.getKey(), action.generateParam((Integer)varMapping.get(paramIndex)));
                        continue;
                    }
                    updatedParams.put(entry.getKey(), entry.getValue());
                    continue;
                }
                updatedParams.put(entry.getKey(), entry.getValue());
            }
            normalizedOutputsAndParams.add(action.toBuilder().parameters(updatedParams).build());
        }
        return this.toBuilder().actions(normalizedOutputsAndParams).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract RuleBuilder build();

        public abstract Builder operator(RuleBuilderStep.Operator var1);

        public abstract Builder conditions(List<RuleBuilderStep> var1);

        public abstract Builder actions(List<RuleBuilderStep> var1);

        public abstract Builder errors(List<String> var1);
    }
}

