/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views;

import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import org.graylog.plugins.views.Requirement;
import org.graylog.plugins.views.search.QueryMetadataDecorator;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.engine.GeneratedQueryContext;
import org.graylog.plugins.views.search.engine.QueryBackend;
import org.graylog.plugins.views.search.engine.QueryStringDecorator;
import org.graylog.plugins.views.search.engine.normalization.PostValidation;
import org.graylog.plugins.views.search.engine.normalization.SearchNormalizer;
import org.graylog.plugins.views.search.engine.validation.SearchValidator;
import org.graylog.plugins.views.search.export.ExportBackend;
import org.graylog.plugins.views.search.rest.SeriesDescription;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.validation.QueryValidator;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.VersionAwareModule;
import org.graylog2.storage.SearchVersion;

public abstract class ViewsModule
extends VersionAwareModule {
    protected LinkedBindingBuilder<ExportBackend> bindExportBackend(SearchVersion supportedVersion) {
        return this.bindForVersion(supportedVersion, ExportBackend.class);
    }

    protected void registerQueryMetadataDecorator(Class<? extends QueryMetadataDecorator> queryMetadataDecorator) {
        this.queryMetadataDecoratorBinder().addBinding().to(queryMetadataDecorator);
    }

    protected Multibinder<QueryMetadataDecorator> queryMetadataDecoratorBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), QueryMetadataDecorator.class);
    }

    protected void registerProvidedViewsCapability(String capability, PluginMetaData plugin) {
        this.viewsCapabilityBinder().addBinding((Object)capability).toInstance((Object)plugin);
    }

    protected MapBinder<String, PluginMetaData> viewsCapabilityBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, PluginMetaData.class);
    }

    protected void registerViewRequirement(Class<? extends Requirement<ViewDTO>> viewRequirement) {
        this.viewRequirementBinder().addBinding().to(viewRequirement);
    }

    protected Multibinder<Requirement<ViewDTO>> viewRequirementBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Requirement<ViewDTO>>(){});
    }

    protected void registerSearchRequirement(Class<? extends Requirement<Search>> searchRequirement) {
        this.searchRequirementBinder().addBinding().to(searchRequirement);
    }

    protected Multibinder<Requirement<Search>> searchRequirementBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Requirement<Search>>(){});
    }

    protected MapBinder<String, SeriesDescription> seriesSpecBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, SeriesDescription.class);
    }

    protected void registerPivotAggregationFunction(String name, String description, Class<? extends SeriesSpec> seriesSpecClass) {
        this.registerJacksonSubtype(seriesSpecClass);
        this.seriesSpecBinder().addBinding((Object)name).toInstance((Object)SeriesDescription.create(name, description));
    }

    protected MapBinder<String, QueryBackend<? extends GeneratedQueryContext>> queryBackendBinder(SearchVersion version) {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<QueryBackend<? extends GeneratedQueryContext>>(){});
    }

    protected ScopedBindingBuilder registerQueryBackend(SearchVersion version, String name, Class<? extends QueryBackend<? extends GeneratedQueryContext>> implementation) {
        return this.queryBackendBinder(version).addBinding((Object)name).to(implementation);
    }

    protected void registerESQueryDecorator(Class<? extends QueryStringDecorator> esQueryDecorator) {
        this.esQueryDecoratorBinder().setBinding().to(esQueryDecorator);
    }

    protected OptionalBinder<QueryStringDecorator> esQueryDecoratorBinder() {
        return OptionalBinder.newOptionalBinder((Binder)this.binder(), QueryStringDecorator.class);
    }

    protected void registerQueryValidator(Class<? extends QueryValidator> validator) {
        this.queryValidatorMultibinder().addBinding().to(validator);
    }

    protected Multibinder<QueryValidator> queryValidatorMultibinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), QueryValidator.class);
    }

    protected void registerSearchNormalizer(Class<? extends SearchNormalizer> normalizer) {
        if (normalizer.getAnnotation(PostValidation.class) != null) {
            this.searchPostValidationNormalizerBinder().addBinding().to(normalizer);
        } else {
            this.searchNormalizerBinder().addBinding().to(normalizer);
        }
    }

    protected Multibinder<SearchNormalizer> searchNormalizerBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), SearchNormalizer.class);
    }

    protected Multibinder<SearchNormalizer> searchPostValidationNormalizerBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), SearchNormalizer.class, PostValidation.class);
    }

    protected void registerSearchValidator(Class<? extends SearchValidator> validator) {
        this.searchValidatorBinder().addBinding().to(validator);
    }

    protected Multibinder<SearchValidator> searchValidatorBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), SearchValidator.class);
    }
}

