/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.ExplainResults;
import org.graylog.plugins.views.search.GlobalOverride;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.GeneratedQueryContext;
import org.graylog.plugins.views.search.engine.QueryExecutionStats;
import org.graylog.plugins.views.search.engine.monitoring.collection.StatsCollector;
import org.graylog.plugins.views.search.errors.QueryError;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.errors.SearchTypeError;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotResult;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public interface QueryBackend<T extends GeneratedQueryContext> {
    public T generate(Query var1, Set<SearchError> var2, DateTimeZone var3);

    public StatsCollector<QueryExecutionStats> getExecutionStatsCollector();

    default public boolean isAllMessages(TimeRange timeRange) {
        return timeRange instanceof RelativeRange && ((RelativeRange)timeRange).isAllMessages();
    }

    default public AbsoluteRange effectiveTimeRangeForResult(Query query, QueryResult queryResult) {
        Optional<AbsoluteRange> effectiveRange;
        TimeRange effectiveTimeRange = query.globalOverride().flatMap(GlobalOverride::timerange).orElse(query.timerange());
        if (this.isAllMessages(effectiveTimeRange) && (effectiveRange = queryResult.searchTypes().values().stream().filter(result -> result instanceof PivotResult).map(result -> ((PivotResult)result).effectiveTimerange()).reduce((prev, next) -> {
            DateTime from = prev.from().compareTo((ReadableInstant)next.from()) < 0 ? prev.from() : next.from();
            DateTime to = prev.to().compareTo((ReadableInstant)next.to()) < 0 ? next.to() : prev.to();
            return AbsoluteRange.create(from, to);
        })).isPresent()) {
            return effectiveRange.get();
        }
        return AbsoluteRange.create(effectiveTimeRange.getFrom(), effectiveTimeRange.getTo());
    }

    default public QueryResult run(SearchJob job, Query query, GeneratedQueryContext generatedQueryContext) {
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            QueryExecutionStats.Builder statsBuilder = QueryExecutionStats.builderWithCurrentTime();
            QueryResult result = this.doRun(job, query, generatedQueryContext);
            stopwatch.stop();
            QueryExecutionStats stats = statsBuilder.duration(stopwatch.elapsed(TimeUnit.MILLISECONDS)).effectiveTimeRange(this.effectiveTimeRangeForResult(query, result)).build();
            this.getExecutionStatsCollector().storeStats(stats);
            return result.toBuilder().executionStats(stats).build();
        }
        catch (Exception e) {
            QueryError queryError = new QueryError(query, e);
            generatedQueryContext.addError(queryError);
            return QueryResult.failedQueryWithError(query, queryError);
        }
    }

    public QueryResult doRun(SearchJob var1, Query var2, T var3);

    default public ExplainResults.QueryExplainResult explain(SearchJob job, Query query, GeneratedQueryContext queryContext) {
        return this.doExplain(job, query, queryContext);
    }

    default public ExplainResults.QueryExplainResult doExplain(SearchJob job, Query query, T queryContext) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        DateTime nowUTCSharedBetweenSearchTypes = Tools.nowUTC();
        query.searchTypes().forEach(s -> {
            Set indicesForQuery = this.indexRangesForStreamsInTimeRange(query.effectiveStreams((SearchType)s), query.effectiveTimeRange((SearchType)s, nowUTCSharedBetweenSearchTypes)).stream().map(ExplainResults.IndexRangeResult::fromIndexRange).collect(Collectors.toSet());
            queryContext.getSearchTypeQueryString(s.id()).ifPresent(queryString -> builder.put((Object)s.id(), (Object)new ExplainResults.ExplainResult((String)queryString, indicesForQuery)));
        });
        return new ExplainResults.QueryExplainResult((Map<String, ExplainResults.ExplainResult>)builder.build());
    }

    public Set<IndexRange> indexRangesForStreamsInTimeRange(Set<String> var1, TimeRange var2);

    default public boolean isSearchTypeWithError(T queryContext, String searchTypeId) {
        return queryContext.errors().stream().filter(q -> q instanceof SearchTypeError).map(q -> (SearchTypeError)q).map(SearchTypeError::searchTypeId).anyMatch(id -> Objects.equals(id, searchTypeId));
    }
}

