/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.ExplainResults;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.elasticsearch.IndexLookup;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.ValidationMessageDTO;
import org.graylog.plugins.views.search.rest.ValidationRequestDTO;
import org.graylog.plugins.views.search.rest.ValidationResponseDTO;
import org.graylog.plugins.views.search.rest.ValidationStatusDTO;
import org.graylog.plugins.views.search.rest.ValidationTypeDTO;
import org.graylog.plugins.views.search.validation.QueryValidationService;
import org.graylog.plugins.views.search.validation.ValidationMessage;
import org.graylog.plugins.views.search.validation.ValidationRequest;
import org.graylog.plugins.views.search.validation.ValidationResponse;
import org.graylog.plugins.views.search.validation.ValidationStatus;
import org.graylog.plugins.views.search.validation.ValidationType;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Search/Validation", tags={"cloud"})
@Path(value="/search/validate")
public class QueryValidationResource
extends RestResource
implements PluginRestResource {
    private final QueryValidationService queryValidationService;
    private final IndexLookup indexLookup;

    @Inject
    public QueryValidationResource(QueryValidationService queryValidationService, IndexLookup indexLookup) {
        this.queryValidationService = queryValidationService;
        this.indexLookup = indexLookup;
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Validate a search query")
    @NoAuditEvent(value="Only validating query structure, not changing any data")
    public ValidationResponseDTO validateQuery(@ApiParam(name="validationRequest") ValidationRequestDTO validationRequest, @Context SearchUser searchUser) {
        ValidationRequest request = this.prepareRequest(validationRequest, searchUser);
        ValidationResponse response = this.queryValidationService.validate(request);
        Set<ExplainResults.IndexRangeResult> searchedIndexRanges = this.indexRanges(request);
        return ValidationResponseDTO.create(this.toStatus(response.status(), this.containsWarmIndices(searchedIndexRanges)), this.toExplanations(response), searchedIndexRanges);
    }

    private boolean containsWarmIndices(Set<ExplainResults.IndexRangeResult> searchedIndexRanges) {
        return searchedIndexRanges.stream().anyMatch(ExplainResults.IndexRangeResult::isWarmTiered);
    }

    private ValidationRequest prepareRequest(ValidationRequestDTO validationRequest, SearchUser searchUser) {
        ValidationRequest.Builder q = ValidationRequest.Builder.builder().query(validationRequest.query()).timerange(validationRequest.timerange().orElse(this.defaultTimeRange())).streams((Set<String>)searchUser.streams().readableOrAllIfEmpty(validationRequest.streams())).parameters(this.resolveParameters(validationRequest)).validationMode(validationRequest.validationMode().toInternalRepresentation());
        validationRequest.filter().ifPresent(q::filter);
        return q.build();
    }

    private Set<ExplainResults.IndexRangeResult> indexRanges(ValidationRequest request) {
        return this.indexLookup.indexRangesForStreamsInTimeRange(request.streams(), request.timerange()).stream().map(ExplainResults.IndexRangeResult::fromIndexRange).collect(Collectors.toSet());
    }

    private ImmutableSet<Parameter> resolveParameters(ValidationRequestDTO validationRequest) {
        return (ImmutableSet)validationRequest.parameters().stream().map(param -> param.applyBindings((Map<String, Parameter.Binding>)validationRequest.parameterBindings())).collect(ImmutableSet.toImmutableSet());
    }

    private ValidationStatusDTO toStatus(ValidationStatus status, boolean hasWarmIndices) {
        ValidationStatusDTO validationStatusDTO;
        switch (status) {
            case WARNING: {
                ValidationStatusDTO validationStatusDTO2 = ValidationStatusDTO.WARNING;
                break;
            }
            case ERROR: {
                ValidationStatusDTO validationStatusDTO2 = ValidationStatusDTO.ERROR;
                break;
            }
            default: {
                ValidationStatusDTO validationStatusDTO2 = validationStatusDTO = ValidationStatusDTO.OK;
            }
        }
        if (validationStatusDTO == ValidationStatusDTO.OK) {
            return hasWarmIndices ? ValidationStatusDTO.WARNING : ValidationStatusDTO.OK;
        }
        return validationStatusDTO;
    }

    private List<ValidationMessageDTO> toExplanations(ValidationResponse response) {
        return response.explanations().stream().map(this::toExplanation).sorted(Comparator.comparing(ValidationMessageDTO::beginLine, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ValidationMessageDTO::beginColumn, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
    }

    private ValidationMessageDTO toExplanation(ValidationMessage message) {
        ValidationTypeDTO validationType = this.convert(message.validationType());
        ValidationMessageDTO.Builder builder = ValidationMessageDTO.builder(validationType, message.errorMessage());
        message.relatedProperty().ifPresent(builder::relatedProperty);
        message.position().ifPresent(queryPosition -> {
            builder.beginLine(queryPosition.beginLine());
            builder.beginColumn(queryPosition.beginColumn());
            builder.endLine(queryPosition.endLine());
            builder.endColumn(queryPosition.endColumn());
        });
        return builder.build();
    }

    private ValidationTypeDTO convert(ValidationType validationType) {
        return ValidationTypeDTO.from(validationType);
    }

    private RelativeRange defaultTimeRange() {
        return RelativeRange.create(300);
    }
}

