/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.contexts;

import jakarta.inject.Inject;
import jakarta.ws.rs.core.SecurityContext;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.Map;
import org.apache.shiro.subject.Subject;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.PermittedStreams;
import org.graylog.plugins.views.search.views.ViewResolver;
import org.graylog.security.UserContext;
import org.graylog2.shared.security.ShiroPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchUserFactory
implements Factory<SearchUser> {
    private static final Logger LOG = LoggerFactory.getLogger(SearchUserFactory.class);
    private final ServiceLocator serviceLocator;
    private final PermittedStreams permittedStreams;
    private final Map<String, ViewResolver> viewResolvers;

    @Inject
    public SearchUserFactory(ServiceLocator serviceLocator, PermittedStreams permittedStreams, Map<String, ViewResolver> viewResolvers) {
        this.serviceLocator = serviceLocator;
        this.permittedStreams = permittedStreams;
        this.viewResolvers = viewResolvers;
    }

    public SearchUser provide() {
        UserContext userContext = (UserContext)this.serviceLocator.getService(UserContext.class, new Annotation[0]);
        SecurityContext securityContext = (SecurityContext)this.serviceLocator.getService(SecurityContext.class, new Annotation[0]);
        Subject subject = this.getSubject(securityContext);
        return new SearchUser(userContext.getUser(), arg_0 -> ((Subject)subject).isPermitted(arg_0), (perm, id) -> subject.isPermitted(perm + ":" + id), this.permittedStreams, this.viewResolvers);
    }

    protected Subject getSubject(SecurityContext securityContext) {
        if (securityContext == null) {
            LOG.error("Cannot retrieve current subject, SecurityContext isn't set.");
            return null;
        }
        Principal p = securityContext.getUserPrincipal();
        if (!(p instanceof ShiroPrincipal)) {
            String msg = "Unknown SecurityContext class " + securityContext + ", cannot continue.";
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        ShiroPrincipal principal = (ShiroPrincipal)p;
        return principal.getSubject();
    }

    public void dispose(SearchUser searchUser) {
    }
}

