/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.QueryFailedException;
import org.graylog.plugins.views.search.rest.scriptingapi.request.RequestedField;
import org.graylog.plugins.views.search.rest.scriptingapi.response.decorators.FieldDecorator;
import org.graylog2.shared.utilities.StringUtils;

public interface TabularResponseCreator {
    default public void throwErrorIfAnyAvailable(QueryResult queryResult) throws QueryFailedException {
        if (!CollectionUtils.isEmpty(queryResult.errors())) {
            String errorText = queryResult.errors().stream().map(SearchError::description).collect(Collectors.joining(", "));
            throw new QueryFailedException("Failed to obtain results. " + errorText);
        }
    }

    default public Object decorate(Set<FieldDecorator> decorators, RequestedField field, Object val, SearchUser searchUser) {
        List<Object> decorated = decorators.stream().filter(d -> d.accept(field)).map(d -> d.decorate(field, val, searchUser)).toList();
        this.checkDecoratorErrors(field, decorated);
        return decorated.stream().findFirst().orElse(val);
    }

    default public void checkDecoratorErrors(RequestedField field, List<Object> decorated) {
        if (decorated.isEmpty() && field.hasDecorator()) {
            throw new UnsupportedOperationException(StringUtils.f("Unsupported property '%s' on field '%s'", field.decorator(), field.name()));
        }
        if (decorated.size() > 1) {
            throw new UnsupportedOperationException(StringUtils.f("Found more decorators supporting '%s' on field '%s', this is not supported operation.", field.decorator(), field.name()));
        }
    }
}

