/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.rest.SearchTypeExecutionState;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog.plugins.views.search.searchtypes.AutoValue_MessageList;
import org.graylog.plugins.views.search.searchtypes.AutoValue_MessageList_Result;
import org.graylog.plugins.views.search.searchtypes.Sort;
import org.graylog.plugins.views.search.timeranges.DerivedTimeRange;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.MessageListEntity;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;
import org.graylog2.decorators.Decorator;
import org.graylog2.decorators.DecoratorImpl;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.rest.models.messages.responses.DecorationStats;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;

@JsonTypeName(value="messages")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class MessageList
implements SearchType {
    public static final String NAME = "messages";

    @Override
    @JsonProperty
    public abstract String type();

    @Override
    @Nullable
    @JsonProperty
    public abstract String id();

    @Override
    @JsonProperty
    public abstract Optional<String> name();

    @Override
    @Nullable
    public abstract Filter filter();

    @Override
    @JsonProperty(value="filters")
    public abstract List<UsedSearchFilter> filters();

    @JsonProperty
    public abstract int limit();

    @JsonProperty
    public abstract int offset();

    @Nullable
    @JsonProperty
    public abstract List<Sort> sort();

    @JsonProperty
    public abstract List<String> fields();

    @JsonProperty
    public abstract List<Decorator> decorators();

    @Override
    public boolean isExportable() {
        return true;
    }

    @JsonCreator
    public static Builder builder() {
        return new AutoValue_MessageList.Builder().type(NAME).limit(150).offset(0).filters(Collections.emptyList()).streams(Collections.emptySet()).decorators(Collections.emptyList()).fields(Collections.emptyList());
    }

    public abstract Builder toBuilder();

    @Override
    public SearchType applyExecutionContext(SearchTypeExecutionState executionState) {
        if (executionState.limit().isPresent() || executionState.offset().isPresent()) {
            Builder builder = this.toBuilder();
            executionState.limit().ifPresent(builder::limit);
            executionState.offset().ifPresent(builder::offset);
            return builder.build();
        }
        return this;
    }

    @Override
    public SearchType withQuery(BackendQuery query) {
        return this.toBuilder().query(query).build();
    }

    @Override
    public SearchType withFilter(Filter filter) {
        return this.toBuilder().filter(filter).build();
    }

    @Override
    public SearchType withFilters(List<UsedSearchFilter> filters) {
        return this.toBuilder().filters(filters).build();
    }

    @Override
    public SearchTypeEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        return ((MessageListEntity.Builder)MessageListEntity.builder().decorators(this.decorators()).streams((Set)this.mappedStreams(entityDescriptorIds))).timerange((DerivedTimeRange)this.timerange().orElse(null)).limit(this.limit()).offset(this.offset()).filter(this.filter()).filters(this.filters()).id(this.id()).name(this.name().orElse(null)).query(this.query().orElse(null)).type(this.type()).sort(this.sort()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder createDefault() {
            return MessageList.builder().filters(Collections.emptyList()).streams(Collections.emptySet());
        }

        @JsonProperty
        public abstract Builder type(String var1);

        @JsonProperty
        public abstract Builder id(@Nullable String var1);

        abstract String id();

        @JsonProperty
        public abstract Builder name(@Nullable String var1);

        @JsonProperty
        public abstract Builder filter(@Nullable Filter var1);

        @JsonProperty(value="filters")
        public abstract Builder filters(List<UsedSearchFilter> var1);

        @JsonProperty
        public abstract Builder fields(List<String> var1);

        @JsonProperty
        public Builder timerange(@Nullable TimeRange timerange) {
            return this.timerange(timerange == null ? null : DerivedTimeRange.of(timerange));
        }

        public abstract Builder timerange(@Nullable DerivedTimeRange var1);

        @JsonProperty
        public abstract Builder query(@Nullable BackendQuery var1);

        @JsonProperty
        public abstract Builder streams(Set<String> var1);

        @JsonProperty
        public abstract Builder limit(int var1);

        @JsonProperty
        public abstract Builder offset(int var1);

        @JsonProperty
        public abstract Builder sort(@Nullable List<Sort> var1);

        @JsonProperty(value="decorators")
        public Builder _decorators(List<DecoratorImpl> decorators) {
            return this.decorators(new ArrayList<Decorator>(decorators));
        }

        public abstract Builder decorators(List<Decorator> var1);

        abstract MessageList autoBuild();

        public MessageList build() {
            if (this.id() == null) {
                this.id(UUID.randomUUID().toString());
            }
            return this.autoBuild();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    @JsonTypeName(value="messages")
    @AutoValue
    public static abstract class Result
    implements SearchType.Result {
        @Override
        @JsonProperty
        public abstract String id();

        @Override
        public abstract String type();

        @JsonProperty
        public abstract List<ResultMessageSummary> messages();

        @JsonProperty
        public abstract Optional<DecorationStats> decorationStats();

        @JsonProperty
        public abstract AbsoluteRange effectiveTimerange();

        @JsonProperty
        public abstract long totalResults();

        public static Builder builder() {
            return new AutoValue_MessageList_Result.Builder().type(MessageList.NAME);
        }

        public static Builder result(String searchTypeId) {
            return Result.builder().id(searchTypeId);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonCreator
            public static Builder create() {
                return new AutoValue_MessageList_Result.Builder().type(MessageList.NAME);
            }

            @JsonProperty
            public abstract Builder id(String var1);

            @JsonProperty
            public abstract Builder name(@Nullable String var1);

            @JsonProperty
            public abstract Builder type(String var1);

            @JsonProperty
            public abstract Builder messages(List<ResultMessageSummary> var1);

            @JsonProperty
            public abstract Builder totalResults(long var1);

            @JsonProperty
            public abstract Builder decorationStats(DecorationStats var1);

            @JsonProperty
            public abstract Builder effectiveTimerange(AbsoluteRange var1);

            public abstract Result build();
        }
    }
}

