/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.storage.migration.state.machine;

import com.github.oxo42.stateless4j.StateMachine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.plugins.views.storage.migration.state.actions.MigrationActions;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationState;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStateMachine;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStateMachineContext;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStep;
import org.graylog.plugins.views.storage.migration.state.persistence.DatanodeMigrationConfiguration;
import org.graylog.plugins.views.storage.migration.state.persistence.DatanodeMigrationPersistence;
import org.graylog.plugins.views.storage.migration.state.rest.CurrentStateInformation;

public class MigrationStateMachineImpl
implements MigrationStateMachine {
    private final StateMachine<MigrationState, MigrationStep> stateMachine;
    private final MigrationActions migrationActions;
    private final DatanodeMigrationPersistence persistenceService;
    private MigrationStateMachineContext context;

    public MigrationStateMachineImpl(StateMachine<MigrationState, MigrationStep> stateMachine, MigrationActions migrationActions, DatanodeMigrationPersistence persistenceService) {
        this.stateMachine = stateMachine;
        this.migrationActions = migrationActions;
        this.persistenceService = persistenceService;
        this.context = persistenceService.getStateMachineContext().orElse(new MigrationStateMachineContext());
        migrationActions.setStateMachineContext(this.context);
    }

    @Override
    public CurrentStateInformation trigger(MigrationStep step, Map<String, Object> args) {
        this.context.setCurrentStep(step);
        if (Objects.nonNull(args) && !args.isEmpty()) {
            this.context.addActionArguments(step, args);
        }
        this.migrationActions.setStateMachineContext(this.context);
        String errorMessage = null;
        try {
            this.stateMachine.fire((Object)step);
        }
        catch (Exception e) {
            errorMessage = Objects.nonNull(e.getMessage()) ? e.getMessage() : e.toString();
        }
        this.context = this.migrationActions.getStateMachineContext();
        this.persistenceService.saveStateMachineContext(this.context);
        return new CurrentStateInformation(this.getState(), this.nextSteps(), errorMessage, this.context.getResponse());
    }

    @Override
    public MigrationStateMachineContext getContext() {
        return this.context;
    }

    @Override
    public MigrationState getState() {
        return (MigrationState)((Object)this.stateMachine.getState());
    }

    @Override
    public List<MigrationStep> nextSteps() {
        return this.stateMachine.getPermittedTriggers();
    }

    @Override
    public String serialize() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.stateMachine.configuration().generateDotFileInto((OutputStream)os, true);
            return os.toString(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize state map", e);
        }
    }

    @Override
    public void reset() {
        this.persistenceService.saveStateMachineContext(new MigrationStateMachineContext());
        this.persistenceService.saveConfiguration(new DatanodeMigrationConfiguration(MigrationState.NEW));
    }
}

