/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.console;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.graylog.security.certutil.console.CommandLineConsole;
import org.graylog.security.certutil.console.ConsoleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestableConsole
implements CommandLineConsole {
    private static final Logger LOG = LoggerFactory.getLogger(TestableConsole.class);
    private final List<Pair<CommandLineConsole.Prompt, String>> providedResponses = new LinkedList<Pair<CommandLineConsole.Prompt, String>>();
    private final List<String> output = new LinkedList<String>();
    private boolean silent = false;

    public static TestableConsole empty() {
        return new TestableConsole();
    }

    public TestableConsole silent() {
        this.silent = true;
        return this;
    }

    public TestableConsole register(CommandLineConsole.Prompt prompt, String response) {
        this.providedResponses.add((Pair<CommandLineConsole.Prompt, String>)Pair.of((Object)prompt, (Object)response));
        return this;
    }

    @Override
    public String readLine(CommandLineConsole.Prompt prompt) {
        String response = this.consumeResponse(prompt);
        return response;
    }

    @Override
    public char[] readPassword(CommandLineConsole.Prompt prompt) {
        String response = this.consumeResponse(prompt);
        return response.toCharArray();
    }

    @Override
    public void printLine(String line) {
        if (!this.silent) {
            LOG.info(line);
        }
        this.output.add(line);
    }

    public List<String> getOutput() {
        return this.output;
    }

    private String consumeResponse(CommandLineConsole.Prompt prompt) {
        Pair response = this.providedResponses.stream().filter(r -> ((CommandLineConsole.Prompt)r.getKey()).equals(prompt)).findFirst().orElseThrow(() -> new ConsoleException("Unexpected input question:" + prompt.question()));
        this.providedResponses.remove(response);
        return (String)response.getValue();
    }
}

