/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration.converters;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MapConverter {
    private static final Splitter ENTRY_SPLITTER = Splitter.on((Pattern)Pattern.compile("\\s*,\\s*")).trimResults().omitEmptyStrings();
    private static final Splitter VALUE_SPLITTER = Splitter.on((Pattern)Pattern.compile(":")).trimResults().omitEmptyStrings().limit(2);

    private static <T> Map<String, T> convertFromValue(String value, Function<String, T> valueConverter) {
        try {
            return ENTRY_SPLITTER.splitToStream((CharSequence)value).map(sequence -> {
                List kv = VALUE_SPLITTER.splitToList((CharSequence)sequence);
                if (kv.size() != 2) {
                    throw new ParameterException("Invalid map entry argument - missing value: " + sequence);
                }
                if (StringUtils.containsWhitespace((CharSequence)((CharSequence)kv.get(0)))) {
                    throw new ParameterException("Invalid map entry argument - key cannot contain spaces: " + sequence);
                }
                try {
                    return Maps.immutableEntry((Object)((String)kv.get(0)), valueConverter.apply((String)kv.get(1)));
                }
                catch (Exception e) {
                    throw new ParameterException("Invalid map entry value: " + sequence, (Throwable)e);
                }
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
                throw new IllegalStateException("Duplicate key in value: " + value);
            }, LinkedHashMap::new));
        }
        catch (ParameterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParameterException("Invalid value - " + e.getMessage(), (Throwable)e);
        }
    }

    private static <T> String convertToValue(Map<String, T> value) {
        return value.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + entry.getValue()).collect(Collectors.joining(","));
    }

    public static class StringInteger
    implements Converter<Map<String, Integer>> {
        public Map<String, Integer> convertFrom(String value) {
            return MapConverter.convertFromValue(value, Integer::parseInt);
        }

        public String convertTo(Map<String, Integer> value) {
            return MapConverter.convertToValue(value);
        }
    }

    public static class StringString
    implements Converter<Map<String, String>> {
        public Map<String, String> convertFrom(String value) {
            return MapConverter.convertFromValue(value, Function.identity());
        }

        public String convertTo(Map<String, String> value) {
            return MapConverter.convertToValue(value);
        }
    }
}

