/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades.dashboardV1;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.graylog.plugins.views.search.db.SearchDbService;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewService;
import org.graylog.plugins.views.search.views.ViewSummaryDTO;
import org.graylog.plugins.views.search.views.ViewSummaryService;
import org.graylog2.contentpacks.facades.ViewFacade;
import org.graylog2.contentpacks.facades.dashboardV1.EntityConverter;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.DashboardEntity;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.ViewEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.UserService;

public class DashboardV1Facade
extends ViewFacade {
    public static final ModelType TYPE_V1 = ModelTypes.DASHBOARD_V1;
    private ObjectMapper objectMapper;
    private EntityConverter entityConverter;

    @Inject
    public DashboardV1Facade(ObjectMapper objectMapper, SearchDbService searchDbService, EntityConverter entityConverter, ViewService viewService, ViewSummaryService viewSummaryService, UserService userService) {
        super(objectMapper, searchDbService, viewService, viewSummaryService, userService);
        this.objectMapper = objectMapper;
        this.entityConverter = entityConverter;
    }

    @Override
    public ViewDTO.Type getDTOType() {
        return ViewDTO.Type.DASHBOARD;
    }

    @Override
    public ModelType getModelType() {
        return ModelTypes.DASHBOARD_V1;
    }

    @Override
    protected Stream<ViewSummaryDTO> getNativeViews() {
        return ImmutableSet.of().stream();
    }

    @Override
    public NativeEntity<ViewDTO> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        this.ensureV1(entity);
        User user = Optional.ofNullable(this.userService.load(username)).orElseThrow(() -> new IllegalStateException("Cannot load user <" + username + "> from db"));
        return this.decode((EntityV1)entity, parameters, nativeEntities, user);
    }

    @Override
    protected NativeEntity<ViewDTO> decode(EntityV1 entityV1, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, User user) {
        EntityV1 convertedEntity = this.convertEntity(entityV1, parameters);
        return super.decode(convertedEntity, parameters, nativeEntities, user);
    }

    private EntityV1 convertEntity(EntityV1 entityV1, Map<String, ValueReference> parameters) {
        DashboardEntity dashboardEntity = (DashboardEntity)this.objectMapper.convertValue((Object)entityV1.data(), DashboardEntity.class);
        ViewEntity viewEntity = this.entityConverter.convert(dashboardEntity, parameters);
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)viewEntity, JsonNode.class);
        return ((EntityV1.Builder)entityV1.toBuilder().data(data).type(ModelTypes.DASHBOARD_V2)).build();
    }

    @Override
    public Graph<Entity> resolveForInstallation(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        this.ensureV1(entity);
        return this.resolveEntityV1((EntityV1)entity, parameters, entities);
    }

    private Graph<Entity> resolveEntityV1(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        DashboardEntity dashboardEntity = (DashboardEntity)this.objectMapper.convertValue((Object)entity.data(), DashboardEntity.class);
        ViewEntity viewEntity = this.entityConverter.convert(dashboardEntity, parameters);
        return this.resolveViewEntity(entity, viewEntity, entities);
    }
}

