/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog2.contentpacks.model.entities.QueryEntity;
import org.graylog2.contentpacks.model.entities.SearchEntity;
import org.joda.time.DateTime;

final class AutoValue_SearchEntity
extends SearchEntity {
    private final ImmutableSet<QueryEntity> queries;
    private final ImmutableSet<Parameter> parameters;
    private final Map<String, PluginMetadataSummary> requires;
    private final Optional<String> owner;
    private final DateTime createdAt;

    private AutoValue_SearchEntity(ImmutableSet<QueryEntity> queries, ImmutableSet<Parameter> parameters, Map<String, PluginMetadataSummary> requires, Optional<String> owner, DateTime createdAt) {
        this.queries = queries;
        this.parameters = parameters;
        this.requires = requires;
        this.owner = owner;
        this.createdAt = createdAt;
    }

    @Override
    @JsonProperty
    public ImmutableSet<QueryEntity> queries() {
        return this.queries;
    }

    @Override
    @JsonProperty
    public ImmutableSet<Parameter> parameters() {
        return this.parameters;
    }

    @Override
    @JsonProperty(value="requires")
    public Map<String, PluginMetadataSummary> requires() {
        return this.requires;
    }

    @Override
    @JsonProperty(value="owner")
    public Optional<String> owner() {
        return this.owner;
    }

    @Override
    @JsonProperty(value="created_at")
    public DateTime createdAt() {
        return this.createdAt;
    }

    public String toString() {
        return "SearchEntity{queries=" + this.queries + ", parameters=" + this.parameters + ", requires=" + this.requires + ", owner=" + this.owner + ", createdAt=" + this.createdAt + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SearchEntity) {
            SearchEntity that = (SearchEntity)o;
            return this.queries.equals(that.queries()) && this.parameters.equals(that.parameters()) && this.requires.equals(that.requires()) && this.owner.equals(that.owner()) && this.createdAt.equals((Object)that.createdAt());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.queries.hashCode();
        h$ *= 1000003;
        h$ ^= this.parameters.hashCode();
        h$ *= 1000003;
        h$ ^= this.requires.hashCode();
        h$ *= 1000003;
        h$ ^= this.owner.hashCode();
        h$ *= 1000003;
        return h$ ^= this.createdAt.hashCode();
    }

    @Override
    public SearchEntity.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SearchEntity.Builder {
        private ImmutableSet<QueryEntity> queries;
        private ImmutableSet<Parameter> parameters;
        private Map<String, PluginMetadataSummary> requires;
        private Optional<String> owner = Optional.empty();
        private DateTime createdAt;

        Builder() {
        }

        private Builder(SearchEntity source) {
            this.queries = source.queries();
            this.parameters = source.parameters();
            this.requires = source.requires();
            this.owner = source.owner();
            this.createdAt = source.createdAt();
        }

        @Override
        public SearchEntity.Builder queries(ImmutableSet<QueryEntity> queries) {
            if (queries == null) {
                throw new NullPointerException("Null queries");
            }
            this.queries = queries;
            return this;
        }

        @Override
        public SearchEntity.Builder parameters(ImmutableSet<Parameter> parameters) {
            if (parameters == null) {
                throw new NullPointerException("Null parameters");
            }
            this.parameters = parameters;
            return this;
        }

        @Override
        public SearchEntity.Builder requires(Map<String, PluginMetadataSummary> requires) {
            if (requires == null) {
                throw new NullPointerException("Null requires");
            }
            this.requires = requires;
            return this;
        }

        @Override
        public SearchEntity.Builder owner(@Nullable String owner) {
            this.owner = Optional.ofNullable(owner);
            return this;
        }

        @Override
        public SearchEntity.Builder createdAt(DateTime createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("Null createdAt");
            }
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public SearchEntity build() {
            if (this.queries == null || this.parameters == null || this.requires == null || this.createdAt == null) {
                StringBuilder missing = new StringBuilder();
                if (this.queries == null) {
                    missing.append(" queries");
                }
                if (this.parameters == null) {
                    missing.append(" parameters");
                }
                if (this.requires == null) {
                    missing.append(" requires");
                }
                if (this.createdAt == null) {
                    missing.append(" createdAt");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SearchEntity(this.queries, this.parameters, this.requires, this.owner, this.createdAt);
        }
    }
}

