/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.MongoIndexSet;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.indexset.events.IndexSetCreatedEvent;
import org.graylog2.indexer.indexset.events.IndexSetDeletedEvent;
import org.graylog2.indexer.indices.TooManyAliasesException;

@Singleton
public class MongoIndexSetRegistry
implements IndexSetRegistry {
    private final IndexSetService indexSetService;
    private final MongoIndexSet.Factory mongoIndexSetFactory;
    private final IndexSetsCache indexSetsCache;

    @Inject
    public MongoIndexSetRegistry(IndexSetService indexSetService, MongoIndexSet.Factory mongoIndexSetFactory, IndexSetsCache indexSetsCache) {
        this.indexSetService = indexSetService;
        this.mongoIndexSetFactory = Objects.requireNonNull(mongoIndexSetFactory);
        this.indexSetsCache = indexSetsCache;
    }

    private Set<MongoIndexSet> findAllMongoIndexSets() {
        List<IndexSetConfig> configs = this.indexSetsCache.get();
        ImmutableSet.Builder mongoIndexSets = ImmutableSet.builder();
        for (IndexSetConfig config : configs) {
            MongoIndexSet mongoIndexSet = this.mongoIndexSetFactory.create(config);
            mongoIndexSets.add((Object)mongoIndexSet);
        }
        return mongoIndexSets.build();
    }

    @Override
    public Set<IndexSet> getAll() {
        return ImmutableSet.copyOf(this.findAllMongoIndexSets());
    }

    @Override
    public Optional<IndexSet> get(String indexSetId) {
        return this.indexSetsCache.get().stream().filter(indexSet -> Objects.equals(indexSet.id(), indexSetId)).map(indexSetConfig -> this.mongoIndexSetFactory.create((IndexSetConfig)indexSetConfig)).findFirst();
    }

    @Override
    public Optional<IndexSet> getForIndex(String indexName) {
        return this.findAllMongoIndexSets().stream().filter(indexSet -> indexSet.isManagedIndex(indexName)).map(indexSet -> indexSet).findFirst();
    }

    @Override
    public Set<IndexSet> getForIndices(Collection<String> indices) {
        Set<MongoIndexSet> indexSets = this.findAllMongoIndexSets();
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (IndexSet indexSet : indexSets) {
            for (String index : indices) {
                if (!indexSet.isManagedIndex(index)) continue;
                resultBuilder.add((Object)indexSet);
            }
        }
        return resultBuilder.build();
    }

    @Override
    public Set<IndexSet> getFromIndexConfig(Collection<IndexSetConfig> indexSetConfigs) {
        ImmutableSet.Builder mongoIndexSets = ImmutableSet.builder();
        for (IndexSetConfig config : indexSetConfigs) {
            MongoIndexSet mongoIndexSet = this.mongoIndexSetFactory.create(config);
            mongoIndexSets.add((Object)mongoIndexSet);
        }
        return ImmutableSet.copyOf((Collection)mongoIndexSets.build());
    }

    @Override
    public IndexSet getDefault() {
        return this.mongoIndexSetFactory.create(this.indexSetService.getDefault());
    }

    @Override
    public String[] getManagedIndices() {
        ImmutableSet.Builder indexNamesBuilder = ImmutableSet.builder();
        for (MongoIndexSet indexSet : this.findAllMongoIndexSets()) {
            indexNamesBuilder.add((Object[])indexSet.getManagedIndices());
        }
        ImmutableSet indexNames = indexNamesBuilder.build();
        return (String[])indexNames.toArray((Object[])new String[0]);
    }

    @Override
    public boolean isManagedIndex(String indexName) {
        return this.isManagedIndex(this.findAllMongoIndexSets(), indexName);
    }

    @Override
    public Map<String, Boolean> isManagedIndex(Collection<String> indices) {
        Set<MongoIndexSet> indexSets = this.findAllMongoIndexSets();
        return indices.stream().collect(Collectors.toMap(Function.identity(), index -> this.isManagedIndex((Collection<? extends IndexSet>)indexSets, (String)index)));
    }

    private boolean isManagedIndex(Collection<? extends IndexSet> indexSets, String index) {
        for (IndexSet indexSet : indexSets) {
            if (!indexSet.isManagedIndex(index)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getIndexWildcards() {
        ImmutableSet.Builder wildcardsBuilder = ImmutableSet.builder();
        for (MongoIndexSet indexSet : this.findAllMongoIndexSets()) {
            if (!indexSet.getConfig().isWritable()) continue;
            wildcardsBuilder.add((Object)indexSet.getIndexWildcard());
        }
        ImmutableSet wildcards = wildcardsBuilder.build();
        return (String[])wildcards.toArray((Object[])new String[0]);
    }

    @Override
    public String[] getWriteIndexAliases() {
        ImmutableSet.Builder indexNamesBuilder = ImmutableSet.builder();
        for (MongoIndexSet indexSet : this.findAllMongoIndexSets()) {
            if (!indexSet.getConfig().isWritable()) continue;
            indexNamesBuilder.add((Object)indexSet.getWriteIndexAlias());
        }
        ImmutableSet indexNames = indexNamesBuilder.build();
        return (String[])indexNames.toArray((Object[])new String[0]);
    }

    @Override
    public boolean isUp() {
        return this.findAllMongoIndexSets().stream().filter(indexSet -> indexSet.getConfig().isWritable()).allMatch(MongoIndexSet::isUp);
    }

    @Override
    public boolean isCurrentWriteIndexAlias(String indexName) {
        for (MongoIndexSet indexSet : this.findAllMongoIndexSets()) {
            if (!indexSet.isWriteIndexAlias(indexName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCurrentWriteIndex(String indexName) throws TooManyAliasesException {
        for (MongoIndexSet indexSet : this.findAllMongoIndexSets()) {
            if (indexSet.getActiveWriteIndex() == null || !indexSet.getActiveWriteIndex().equals(indexName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<IndexSet> iterator() {
        return this.getAll().iterator();
    }

    static class IndexSetsCache {
        private final IndexSetService indexSetService;
        private AtomicReference<Supplier<List<IndexSetConfig>>> indexSetConfigs;

        @Inject
        IndexSetsCache(IndexSetService indexSetService, EventBus serverEventBus) {
            this.indexSetService = Objects.requireNonNull(indexSetService);
            this.indexSetConfigs = new AtomicReference<Supplier>(Suppliers.memoize(this.indexSetService::findAll));
            serverEventBus.register((Object)this);
        }

        List<IndexSetConfig> get() {
            return Collections.unmodifiableList((List)this.indexSetConfigs.get().get());
        }

        @VisibleForTesting
        void invalidate() {
            this.indexSetConfigs.set((Supplier<List<IndexSetConfig>>)Suppliers.memoize(this.indexSetService::findAll));
        }

        @Subscribe
        void handleIndexSetCreation(IndexSetCreatedEvent indexSetCreatedEvent) {
            this.invalidate();
        }

        @Subscribe
        void handleIndexSetDeletion(IndexSetDeletedEvent indexSetDeletedEvent) {
            this.invalidate();
        }
    }
}

