/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.fieldtypes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.indexer.fieldtypes.FieldTypeDTO;
import org.graylog2.indexer.fieldtypes.FieldTypeLookup;
import org.graylog2.indexer.fieldtypes.FieldTypeMapper;
import org.graylog2.indexer.fieldtypes.FieldTypes;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesService;

public class MongoFieldTypeLookup
implements FieldTypeLookup {
    private final IndexFieldTypesService dbService;
    private final FieldTypeMapper typeMapper;

    @Inject
    public MongoFieldTypeLookup(IndexFieldTypesService dbService, FieldTypeMapper typeMapper) {
        this.dbService = dbService;
        this.typeMapper = typeMapper;
    }

    @Override
    public Optional<FieldTypes> get(String fieldName) {
        return Optional.ofNullable(this.get((Collection<String>)ImmutableSet.of((Object)fieldName)).get(fieldName));
    }

    @Override
    public Map<String, FieldTypes> get(Collection<String> fieldNames) {
        return this.get(fieldNames, (Collection<String>)ImmutableSet.of());
    }

    @Override
    public Map<String, FieldTypes> get(Collection<String> fieldNames, Collection<String> indexNames) {
        if (fieldNames.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap fields = new HashMap();
        this.getTypesStream(fieldNames, indexNames).stream().filter(types -> indexNames.isEmpty() || indexNames.contains(types.indexName())).forEach(types -> {
            String indexName = types.indexName();
            types.fields().stream().filter(fieldType -> fieldNames.contains(fieldType.fieldName())).forEach(fieldType -> {
                String fieldName = fieldType.fieldName();
                fields.merge(fieldName, Collections.singletonMap(fieldType, Collections.singleton(indexName)), (existingMap, newMap) -> {
                    HashMap<FieldTypeDTO, Set> result = new HashMap<FieldTypeDTO, Set>((Map<FieldTypeDTO, Set>)existingMap);
                    result.merge((FieldTypeDTO)fieldType, Collections.singleton(indexName), Sets::union);
                    return result;
                });
            });
        });
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry fieldNameEntry : fields.entrySet()) {
            String fieldName = (String)fieldNameEntry.getKey();
            Map physicalTypes = (Map)fieldNameEntry.getValue();
            Set<FieldTypes.Type> types2 = physicalTypes.entrySet().stream().map(entry -> {
                FieldTypeDTO physicalType = (FieldTypeDTO)entry.getKey();
                ImmutableSet indices = ImmutableSet.copyOf((Collection)((Collection)entry.getValue()));
                return this.typeMapper.mapType(physicalType).map(arg_0 -> MongoFieldTypeLookup.lambda$get$5((Set)indices, arg_0));
            }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            result.put((Object)fieldName, (Object)FieldTypes.create(fieldName, types2));
        }
        return result.build();
    }

    private Collection<IndexFieldTypesDTO> getTypesStream(Collection<String> fieldNames, Collection<String> indexNames) {
        if (indexNames.isEmpty()) {
            return this.dbService.findForFieldNames(fieldNames);
        }
        return this.dbService.findForFieldNamesAndIndices(fieldNames, indexNames);
    }

    private static /* synthetic */ FieldTypes.Type lambda$get$5(Set indices, FieldTypes.Type t) {
        return t.withIndexNames(indices);
    }
}

