/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indices.util;

import java.util.Comparator;

public class NumberBasedIndexNameComparator
implements Comparator<String> {
    private final String separator;

    public NumberBasedIndexNameComparator(String separator) {
        this.separator = separator;
    }

    @Override
    public int compare(String indexName1, String indexName2) {
        int index2Number;
        int index1Number;
        int separatorPosition = indexName1.lastIndexOf(this.separator);
        String indexPrefix1 = separatorPosition != -1 ? indexName1.substring(0, separatorPosition) : indexName1;
        try {
            index1Number = Integer.parseInt(indexName1.substring(separatorPosition + 1));
        }
        catch (Exception e) {
            index1Number = Integer.MIN_VALUE;
        }
        separatorPosition = indexName2.lastIndexOf(this.separator);
        String indexPrefix2 = separatorPosition != -1 ? indexName2.substring(0, separatorPosition) : indexName2;
        try {
            index2Number = Integer.parseInt(indexName2.substring(separatorPosition + 1));
        }
        catch (NumberFormatException e) {
            index2Number = Integer.MIN_VALUE;
        }
        int prefixComparisonResult = indexPrefix1.compareTo(indexPrefix2);
        if (prefixComparisonResult == 0) {
            return -Integer.compare(index1Number, index2Number);
        }
        return prefixComparisonResult;
    }
}

