/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.retention.executors;

import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.periodical.IndexRetentionThread;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetentionExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RetentionExecutor.class);
    private final ActivityWriter activityWriter;
    private final Indices indices;

    @Inject
    public RetentionExecutor(ActivityWriter activityWriter, Indices indices) {
        this.activityWriter = activityWriter;
        this.indices = indices;
    }

    private static boolean hasCurrentWriteAlias(IndexSet indexSet, Map<String, Set<String>> deflectorIndices, String indexName) {
        return deflectorIndices.getOrDefault(indexName, Collections.emptySet()).contains(indexSet.getWriteIndexAlias());
    }

    public void runRetention(IndexSet indexSet, int removeCount, RetentionAction action, String actionName) {
        Map<String, Set<String>> deflectorIndices = indexSet.getAllIndexAliases();
        Set orderedIndices = Arrays.stream(indexSet.getManagedIndices()).filter(indexName -> !this.indices.isReopened((String)indexName)).filter(indexName -> !RetentionExecutor.hasCurrentWriteAlias(indexSet, deflectorIndices, indexName)).sorted(indexSet.indexComparator()).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedList<String> orderedIndicesDescending = new LinkedList<String>();
        orderedIndices.stream().skip(orderedIndices.size() - removeCount).collect(Collectors.toCollection(LinkedList::new)).descendingIterator().forEachRemaining(orderedIndicesDescending::add);
        String indexNamesAsString = String.join((CharSequence)", ", orderedIndicesDescending);
        String msg = "Running retention action [" + actionName + "] for indices <" + indexNamesAsString + ">";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
        action.retain(orderedIndicesDescending, indexSet);
    }

    public static interface RetentionAction {
        public void retain(List<String> var1, IndexSet var2);
    }
}

