/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports;

import com.codahale.metrics.MetricSet;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import jakarta.inject.Named;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.graylog2.plugin.InputFailureRecorder;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.DropdownField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.MisfireException;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.inputs.transports.ThrottleableTransport;
import org.graylog2.plugin.inputs.transports.ThrottleableTransport2;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.journal.RawMessage;
import org.graylog2.plugin.lifecycles.Lifecycle;
import org.graylog2.security.encryption.EncryptedValue;
import org.graylog2.security.encryption.EncryptedValueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPollTransport
extends ThrottleableTransport2 {
    private static final Logger LOG = LoggerFactory.getLogger(HttpPollTransport.class);
    private static final String CK_URL = "target_url";
    public static final String CK_HTTP_METHOD = "http_method";
    public static final String CK_HTTP_BODY = "http_body";
    public static final String CK_CONTENT_TYPE = "content_type";
    private static final String CK_HEADERS = "headers";
    private static final String CK_ENCRYPTED_HEADERS = "encrypted_headers";
    private static final String CK_TIMEUNIT = "timeunit";
    private static final String CK_INTERVAL = "interval";
    public static final String GET = "GET";
    public static final String PUT = "PUT";
    public static final String POST = "POST";
    private final Configuration configuration;
    private final EventBus serverEventBus;
    private final ServerStatus serverStatus;
    private final ScheduledExecutorService scheduler;
    private final OkHttpClient httpClient;
    private final EncryptedValueService encryptedValueService;
    private volatile boolean paused = true;
    private ScheduledFuture<?> scheduledFuture;

    @AssistedInject
    public HttpPollTransport(@Assisted Configuration configuration, EventBus serverEventBus, ServerStatus serverStatus, @Named(value="daemonScheduler") ScheduledExecutorService scheduler, OkHttpClient httpClient, EncryptedValueService encryptedValueService) {
        super(serverEventBus, configuration);
        this.configuration = configuration;
        this.serverEventBus = serverEventBus;
        this.serverStatus = serverStatus;
        this.scheduler = scheduler;
        this.httpClient = httpClient;
        this.encryptedValueService = encryptedValueService;
    }

    @VisibleForTesting
    static Map<String, String> parseHeaders(String headerString) {
        if (Strings.isNullOrEmpty((String)headerString)) {
            return Collections.emptyMap();
        }
        HashMap headers = Maps.newHashMap();
        for (String headerPart : headerString.trim().split(",")) {
            String[] parts = headerPart.trim().split(":");
            if (parts.length != 2) continue;
            headers.put(parts[0].trim(), parts[1].trim());
        }
        return headers;
    }

    @Subscribe
    public void lifecycleStateChange(Lifecycle lifecycle) {
        LOG.debug("Lifecycle changed to {}", (Object)lifecycle);
        switch (lifecycle) {
            case RUNNING: {
                this.paused = false;
                break;
            }
            default: {
                this.paused = true;
            }
        }
    }

    @Override
    public void setMessageAggregator(CodecAggregator aggregator) {
    }

    @Override
    public void doLaunch(MessageInput input, InputFailureRecorder inputFailureRecorder) throws MisfireException {
        InetSocketAddress remoteAddress1;
        this.serverStatus.awaitRunning(() -> this.lifecycleStateChange(Lifecycle.RUNNING));
        this.serverEventBus.register((Object)this);
        Map<String, String> headers = HttpPollTransport.parseHeaders(this.getHeaderString());
        String url = this.configuration.getString(CK_URL);
        try {
            URL url1 = new URL(url);
            int port = url1.getPort();
            remoteAddress1 = new InetSocketAddress(url1.getHost(), port != -1 ? port : 80);
        }
        catch (MalformedURLException e) {
            remoteAddress1 = null;
        }
        InetSocketAddress remoteAddress = remoteAddress1;
        Runnable task = () -> {
            if (this.paused) {
                LOG.debug("Message processing paused, not polling HTTP resource {}.", (Object)url);
                return;
            }
            if (this.isThrottled()) {
                LOG.debug("Not polling HTTP resource {} because we are throttled.", (Object)url);
                return;
            }
            Request.Builder requestBuilder = this.getRequestBuilder().url(url).headers(Headers.of((Map)headers));
            try (Response r = this.httpClient.newCall(requestBuilder.build()).execute();){
                if (!r.isSuccessful()) {
                    LOG.error("Expected successful HTTP status code [2xx], got " + r.code());
                    return;
                }
                input.processRawMessage(new RawMessage(r.body().bytes(), remoteAddress));
                inputFailureRecorder.setRunning();
            }
            catch (IOException e) {
                inputFailureRecorder.setFailing(this.getClass(), "Could not fetch HTTP resource at " + url, e);
            }
        };
        this.scheduledFuture = this.scheduler.scheduleAtFixedRate(task, 0L, this.configuration.getInt(CK_INTERVAL), TimeUnit.valueOf(this.configuration.getString(CK_TIMEUNIT)));
    }

    private String getHeaderString() {
        String standardHeaders = Objects.requireNonNullElse(this.configuration.getString(CK_HEADERS), "");
        EncryptedValue encryptedHeaders = Objects.requireNonNullElse(this.configuration.getEncryptedValue(CK_ENCRYPTED_HEADERS), EncryptedValue.createUnset());
        String decryptedHeaders = Objects.requireNonNullElse(this.encryptedValueService.decrypt(encryptedHeaders), "");
        return Stream.of(standardHeaders, decryptedHeaders).map(String::strip).filter(s -> !s.isBlank()).collect(Collectors.joining(","));
    }

    @VisibleForTesting
    Request.Builder getRequestBuilder() {
        Request.Builder requestBuilder = new Request.Builder();
        String httpMethod = this.configuration.getString(CK_HTTP_METHOD);
        if (httpMethod == null || httpMethod.equals(GET)) {
            return requestBuilder.get();
        }
        String body = this.configuration.getString(CK_HTTP_BODY);
        MediaType contentType = MediaType.parse((String)this.configuration.getString(CK_CONTENT_TYPE));
        switch (httpMethod) {
            case "PUT": {
                requestBuilder.put(RequestBody.create((String)body, (MediaType)contentType));
                break;
            }
            case "POST": {
                requestBuilder.post(RequestBody.create((String)body, (MediaType)contentType));
            }
        }
        return requestBuilder;
    }

    @Override
    public void doStop() {
        this.serverEventBus.unregister((Object)this);
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    @Override
    public MetricSet getMetricSet() {
        return null;
    }

    @ConfigClass
    public static class Config
    extends ThrottleableTransport.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest r = super.getRequestedConfiguration();
            r.addField(new TextField(HttpPollTransport.CK_URL, "URI of JSON resource", "http://example.org/api", "HTTP resource returning JSON on HTTP request", ConfigurationField.Optional.NOT_OPTIONAL));
            r.addField(new DropdownField(HttpPollTransport.CK_HTTP_METHOD, "HTTP method", HttpPollTransport.GET, Map.of(HttpPollTransport.GET, HttpPollTransport.GET, HttpPollTransport.PUT, HttpPollTransport.PUT, HttpPollTransport.POST, HttpPollTransport.POST), "HTTP method to use for the requests.", ConfigurationField.Optional.OPTIONAL));
            r.addField(new TextField(HttpPollTransport.CK_HTTP_BODY, "HTTP body", "", "HTTP body for POST/PUT requests. Required for POST/PUT.", ConfigurationField.Optional.OPTIONAL));
            r.addField(new DropdownField(HttpPollTransport.CK_CONTENT_TYPE, "HTTP content type", "", Map.of("application/json", "application/json", "application/x-www-form-urlencoded", "application/x-www-form-urlencoded", "text/plain", "text/plain"), "HTTP content type for POST/PUT requests. Required for POST/PUT.", ConfigurationField.Optional.OPTIONAL));
            r.addField(new TextField(HttpPollTransport.CK_ENCRYPTED_HEADERS, "Additional, sensitive HTTP headers.", "", "Add a comma separated list of HTTP headers containing sensitive information, e.g. for authorization. For example: Authorization: Bearer <token>", ConfigurationField.Optional.OPTIONAL, true, new TextField.Attribute[0]));
            r.addField(new TextField(HttpPollTransport.CK_HEADERS, "Additional HTTP headers", "", "Add a comma separated list of additional HTTP headers. For example: Accept: application/json, X-Requester: Graylog", ConfigurationField.Optional.OPTIONAL));
            r.addField(new NumberField(HttpPollTransport.CK_INTERVAL, "Interval", 1, "Time between every collector run. Select a time unit in the corresponding dropdown. Example: Run every 5 minutes.", ConfigurationField.Optional.NOT_OPTIONAL));
            r.addField(new DropdownField(HttpPollTransport.CK_TIMEUNIT, "Interval time unit", TimeUnit.MINUTES.toString(), DropdownField.ValueTemplates.timeUnits(), ConfigurationField.Optional.NOT_OPTIONAL));
            return r;
        }
    }

    @FactoryClass
    public static interface Factory
    extends Transport.Factory<HttpPollTransport> {
        @Override
        public HttpPollTransport create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

