/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.adapters;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.HttpUrl;
import org.graylog2.lookup.adapters.$AutoValue_DSVHTTPDataAdapter_Config;
import org.graylog2.lookup.adapters.LookupDataAdapterValidationContext;
import org.graylog2.lookup.adapters.dsvhttp.DSVParser;
import org.graylog2.lookup.adapters.dsvhttp.HTTPFileRetriever;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.system.urlwhitelist.UrlNotWhitelistedException;
import org.graylog2.system.urlwhitelist.UrlWhitelistNotificationService;
import org.graylog2.system.urlwhitelist.UrlWhitelistService;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSVHTTPDataAdapter
extends LookupDataAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DSVHTTPDataAdapter.class);
    public static final String NAME = "dsvhttp";
    private final Config config;
    private final HTTPFileRetriever httpFileRetriever;
    private final AtomicReference<Map<String, String>> lookupRef = new AtomicReference(Collections.emptyMap());
    private final DSVParser dsvParser;
    private final UrlWhitelistService whitelistService;
    private final UrlWhitelistNotificationService urlWhitelistNotificationService;

    @Inject
    public DSVHTTPDataAdapter(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupDataAdapterConfiguration config, MetricRegistry metricRegistry, HTTPFileRetriever httpFileRetriever, UrlWhitelistService whitelistService, UrlWhitelistNotificationService urlWhitelistNotificationService) {
        super(id, name, config, metricRegistry);
        this.config = (Config)config;
        this.httpFileRetriever = httpFileRetriever;
        this.whitelistService = whitelistService;
        this.urlWhitelistNotificationService = urlWhitelistNotificationService;
        this.dsvParser = new DSVParser(this.config.ignorechar(), this.config.lineSeparator(), this.config.separator(), this.config.quotechar(), this.config.isCheckPresenceOnly(), this.config.isCaseInsensitiveLookup(), this.config.keyColumn(), this.config.valueColumn());
    }

    @Override
    public void doStart() throws Exception {
        LOG.debug("Starting HTTP DSV data adapter for URL: {}", (Object)this.config.url());
        if (Strings.isNullOrEmpty((String)this.config.url())) {
            throw new IllegalStateException("File path needs to be set");
        }
        if (this.config.refreshInterval() < 1L) {
            throw new IllegalStateException("Check interval setting cannot be smaller than 1");
        }
        if (!this.whitelistService.isWhitelisted(this.config.url())) {
            this.publishSystemNotificationForWhitelistFailure();
            throw UrlNotWhitelistedException.forUrl(this.config.url());
        }
        Optional<String> response = this.httpFileRetriever.fetchFileIfNotModified(this.config.url());
        response.ifPresent(body -> this.lookupRef.set(this.dsvParser.parse((String)body)));
    }

    @Override
    public Duration refreshInterval() {
        return Duration.standardSeconds((long)Ints.saturatedCast((long)this.config.refreshInterval()));
    }

    @Override
    protected void doRefresh(LookupCachePurge cachePurge) throws Exception {
        if (!this.whitelistService.isWhitelisted(this.config.url())) {
            this.setError(UrlNotWhitelistedException.forUrl(this.config.url()));
            this.publishSystemNotificationForWhitelistFailure();
            return;
        }
        boolean urlWasNotWhitelisted = this.getError().filter(UrlNotWhitelistedException.class::isInstance).isPresent();
        try {
            Optional<String> response = urlWasNotWhitelisted ? this.httpFileRetriever.fetchFile(this.config.url()) : this.httpFileRetriever.fetchFileIfNotModified(this.config.url());
            response.ifPresent(body -> {
                LOG.debug("DSV file {} has changed, updating data", (Object)this.config.url());
                this.lookupRef.set(this.dsvParser.parse((String)body));
                cachePurge.purgeAll();
                this.clearError();
            });
        }
        catch (Exception e) {
            LOG.error("Couldn't check data adapter <{}> DSV file {} for updates: {} {}", new Object[]{this.name(), this.config.url(), e.getClass().getCanonicalName(), e.getMessage()});
            this.setError(e);
        }
    }

    @Override
    public void doStop() throws Exception {
        LOG.debug("Stopping HTTP DSV data adapter for url: {}", (Object)this.config.url());
    }

    @Override
    public LookupResult doGet(Object key) {
        String stringKey;
        String string = stringKey = this.config.isCaseInsensitiveLookup() ? String.valueOf(key).toLowerCase(Locale.ENGLISH) : String.valueOf(key);
        if (this.config.isCheckPresenceOnly()) {
            return LookupResult.single(this.lookupRef.get().containsKey(stringKey));
        }
        String value = this.lookupRef.get().get(stringKey);
        if (value == null) {
            return LookupResult.empty();
        }
        return LookupResult.single(value);
    }

    @Override
    public void set(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    private void publishSystemNotificationForWhitelistFailure() {
        String description = "A \"DSV File from HTTP\" lookup adapter is trying to access a URL which is not whitelisted. Please check your configuration. [adapter name: \"" + this.name() + "\", url: \"" + this.config.url() + "\"]";
        this.urlWhitelistNotificationService.publishWhitelistFailure(description);
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=$AutoValue_DSVHTTPDataAdapter_Config.Builder.class)
    @JsonTypeName(value="dsvhttp")
    @AutoValue
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        @Override
        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="url")
        @NotEmpty
        public abstract String url();

        @JsonProperty(value="separator")
        @Size(min=1, max=1)
        @NotEmpty
        public abstract @Size(min=1, max=1) @NotEmpty String separator();

        @JsonProperty(value="line_separator")
        @Size(min=1, max=1)
        @NotEmpty
        public abstract @Size(min=1, max=1) @NotEmpty String lineSeparator();

        @JsonProperty(value="quotechar")
        @Size(min=1, max=1)
        @NotEmpty
        public abstract @Size(min=1, max=1) @NotEmpty String quotechar();

        @JsonProperty(value="ignorechar")
        @Size(min=1)
        @NotEmpty
        public abstract @Size(min=1) @NotEmpty String ignorechar();

        @JsonProperty(value="key_column")
        @NotEmpty
        public abstract Integer keyColumn();

        @JsonProperty(value="check_presence_only")
        public abstract Optional<Boolean> checkPresenceOnly();

        @JsonProperty(value="value_column")
        @NotEmpty
        public abstract Optional<Integer> valueColumn();

        @JsonProperty(value="refresh_interval")
        @Min(value=1L)
        public abstract @Min(value=1L) long refreshInterval();

        @JsonProperty(value="case_insensitive_lookup")
        public abstract Optional<Boolean> caseInsensitiveLookup();

        public boolean isCaseInsensitiveLookup() {
            return this.caseInsensitiveLookup().orElse(false);
        }

        public boolean isCheckPresenceOnly() {
            return this.checkPresenceOnly().orElse(false);
        }

        public static Builder builder() {
            return new $AutoValue_DSVHTTPDataAdapter_Config.Builder();
        }

        @Override
        public Optional<Multimap<String, String>> validate(LookupDataAdapterValidationContext validationContext) {
            ArrayListMultimap errors = ArrayListMultimap.create();
            if (HttpUrl.parse((String)this.url()) == null) {
                errors.put((Object)"url", (Object)("Unable to parse url: " + this.url()));
            } else if (!validationContext.getUrlWhitelistService().isWhitelisted(this.url())) {
                errors.put((Object)"url", (Object)("URL <" + this.url() + "> is not whitelisted."));
            }
            return errors.isEmpty() ? Optional.empty() : Optional.of(errors);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="url")
            public abstract Builder url(String var1);

            @JsonProperty(value="separator")
            public abstract Builder separator(String var1);

            @JsonProperty(value="line_separator")
            public abstract Builder lineSeparator(String var1);

            @JsonProperty(value="quotechar")
            public abstract Builder quotechar(String var1);

            @JsonProperty(value="ignorechar")
            public abstract Builder ignorechar(String var1);

            @JsonProperty(value="key_column")
            public abstract Builder keyColumn(Integer var1);

            @JsonProperty(value="value_column")
            public abstract Builder valueColumn(Integer var1);

            @JsonProperty(value="refresh_interval")
            public abstract Builder refreshInterval(long var1);

            @JsonProperty(value="case_insensitive_lookup")
            public abstract Builder caseInsensitiveLookup(Boolean var1);

            @JsonProperty(value="check_presence_only")
            public abstract Builder checkPresenceOnly(Boolean var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(DSVHTTPDataAdapter.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(DSVHTTPDataAdapter.NAME).url("https://example.org/table.csv").separator(",").lineSeparator("\n").quotechar("\"").ignorechar("#").keyColumn(0).valueColumn(1).refreshInterval(60L).caseInsensitiveLookup(false).checkPresenceOnly(false).build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory<DSVHTTPDataAdapter> {
        @Override
        public DSVHTTPDataAdapter create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupDataAdapterConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

