/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.caches;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import com.google.auto.value.AutoValue;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import jakarta.validation.constraints.Min;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.graylog2.lookup.caches.$AutoValue_CaffeineLookupCache_Config;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupCacheConfiguration;
import org.graylog2.plugin.lookup.LookupCacheKey;
import org.graylog2.plugin.lookup.LookupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineLookupCache
extends LookupCache {
    private static final Logger LOG = LoggerFactory.getLogger(CaffeineLookupCache.class);
    public static final String NAME = "guava_cache";
    public static final String MAX_SIZE = "max_size";
    public static final String EXPIRE_AFTER_ACCESS = "expire_after_access";
    public static final String EXPIRE_AFTER_ACCESS_UNIT = "expire_after_access_unit";
    public static final String EXPIRE_AFTER_WRITE = "expire_after_write";
    public static final String EXPIRE_AFTER_WRITE_UNIT = "expire_after_write_unit";
    public static final String IGNORE_NULL = "ignore_null";
    public static final String TTL_EMPTY = "ttl_empty";
    public static final String TTL_EMPTY_UNIT = "ttl_empty_unit";
    private final Cache<LookupCacheKey, LookupResult> cache;
    private final Config config;

    @Inject
    public CaffeineLookupCache(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupCacheConfiguration c, MetricRegistry metricRegistry) {
        super(id, name, c, metricRegistry);
        this.config = (Config)c;
        this.cache = Caffeine.newBuilder().recordStats(() -> new MetricStatsCounter(this)).maximumSize((long)this.config.maxSize()).expireAfter(this.buildExpiry(this.config)).build();
    }

    public CaffeineLookupCache(String id, String name, LookupCacheConfiguration c, MetricRegistry metricRegistry, Ticker fakeTicker) {
        super(id, name, c, metricRegistry);
        this.config = (Config)c;
        this.cache = Caffeine.newBuilder().recordStats(() -> new MetricStatsCounter(this)).maximumSize((long)this.config.maxSize()).expireAfter(this.buildExpiry(this.config)).ticker(fakeTicker).build();
    }

    private Expiry<LookupCacheKey, LookupResult> buildExpiry(final Config config) {
        return new Expiry<LookupCacheKey, LookupResult>(){

            public long expireAfterCreate(@NonNull LookupCacheKey lookupCacheKey, @NonNull LookupResult lookupResult, long currentTime) {
                if (lookupResult.hasTTL()) {
                    return TimeUnit.MILLISECONDS.toNanos(lookupResult.cacheTTL());
                }
                if (config.expireAfterWrite() > 0L && config.expireAfterWriteUnit() != null) {
                    return config.expireAfterWriteUnit().toNanos(config.expireAfterWrite());
                }
                return Long.MAX_VALUE;
            }

            public long expireAfterUpdate(@NonNull LookupCacheKey lookupCacheKey, @NonNull LookupResult lookupResult, long currentTime, long currentDuration) {
                return currentDuration;
            }

            public long expireAfterRead(@NonNull LookupCacheKey lookupCacheKey, @NonNull LookupResult lookupResult, long currentTime, long currentDuration) {
                if (config.ttlEmpty() != null && !Boolean.TRUE.equals(config.ignoreNull()) && lookupResult.isEmpty()) {
                    LOG.trace("afterRead: empty: {}", (Object)currentDuration);
                    return currentDuration;
                }
                if (config.expireAfterAccess() > 0L && config.expireAfterAccessUnit() != null) {
                    LOG.trace("afterRead: config: {}", (Object)config.expireAfterAccessUnit().toNanos(config.expireAfterAccess()));
                    return config.expireAfterAccessUnit().toNanos(config.expireAfterAccess());
                }
                LOG.trace("afterRead: {}", (Object)currentDuration);
                return currentDuration;
            }
        };
    }

    @Override
    public long entryCount() {
        if (this.cache != null) {
            return this.cache.estimatedSize();
        }
        return 0L;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    public LookupResult get(LookupCacheKey key, Callable<LookupResult> loader) {
        Function<LookupCacheKey, LookupResult> mapFunction = unused -> {
            try {
                LookupResult result = (LookupResult)loader.call();
                if (this.ignoreResult(result, this.config.ignoreNull())) {
                    LOG.trace("Ignoring failed lookup for key {}", (Object)key);
                    return LookupResult.builder().cacheTTL(0L).build();
                }
                if (this.isResultEmpty(result)) {
                    LOG.trace("Empty lookup for key {} with TTL {}", (Object)key, (Object)this.ttlEmptyMillis());
                    return LookupResult.builder().cacheTTL(this.ttlEmptyMillis()).build();
                }
                return result;
            }
            catch (Exception e) {
                LOG.warn("Loading value from data adapter failed for key {}, returning empty result", (Object)key, (Object)e);
                return LookupResult.withError(String.format(Locale.ENGLISH, "Loading value from data adapter failed for key <%s>: %s", key.toString(), e.getMessage()));
            }
        };
        try (Timer.Context ignored = this.lookupTimer();){
            LookupResult lookupResult = (LookupResult)this.cache.get((Object)key, mapFunction);
            return lookupResult;
        }
    }

    private boolean ignoreResult(LookupResult result, Boolean ignoreNull) {
        if (Boolean.TRUE.equals(ignoreNull)) {
            return this.isResultEmpty(result);
        }
        return false;
    }

    private boolean isResultEmpty(LookupResult result) {
        return result == null || result.singleValue() == null && result.multiValue() == null && result.stringListValue() == null;
    }

    private long ttlEmptyMillis() {
        if (this.config.ttlEmpty() != null && this.config.ttlEmptyUnit() != null) {
            return this.config.ttlEmptyUnit().toMillis(this.config.ttlEmpty());
        }
        return Long.MAX_VALUE;
    }

    @Override
    public LookupResult getIfPresent(LookupCacheKey key) {
        LookupResult cacheEntry = (LookupResult)this.cache.getIfPresent((Object)key);
        if (cacheEntry == null) {
            return LookupResult.empty();
        }
        return cacheEntry;
    }

    @Override
    public void purge() {
        this.cache.invalidateAll();
    }

    @Override
    public void purge(LookupCacheKey purgeKey) {
        if (purgeKey.isPrefixOnly()) {
            this.cache.invalidateAll((Iterable)this.cache.asMap().keySet().stream().filter(lookupCacheKey -> purgeKey.prefix().equals(lookupCacheKey.prefix())).collect(Collectors.toSet()));
        } else {
            this.cache.invalidate((Object)purgeKey);
        }
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=$AutoValue_CaffeineLookupCache_Config.Builder.class)
    @JsonTypeName(value="guava_cache")
    @AutoValue
    public static abstract class Config
    implements LookupCacheConfiguration {
        @Min(value=0L)
        @JsonProperty(value="max_size")
        public abstract @Min(value=0L) int maxSize();

        @Min(value=0L)
        @JsonProperty(value="expire_after_access")
        public abstract @Min(value=0L) long expireAfterAccess();

        @Nullable
        @JsonProperty(value="expire_after_access_unit")
        public abstract TimeUnit expireAfterAccessUnit();

        @Min(value=0L)
        @JsonProperty(value="expire_after_write")
        public abstract @Min(value=0L) long expireAfterWrite();

        @Nullable
        @JsonProperty(value="expire_after_write_unit")
        public abstract TimeUnit expireAfterWriteUnit();

        @Nullable
        @JsonProperty(value="ignore_null")
        public abstract Boolean ignoreNull();

        @Min(value=0L)
        @Nullable
        @JsonProperty(value="ttl_empty")
        public abstract @Min(value=0L) Long ttlEmpty();

        @Nullable
        @JsonProperty(value="ttl_empty_unit")
        public abstract TimeUnit ttlEmptyUnit();

        public static Builder builder() {
            return new $AutoValue_CaffeineLookupCache_Config.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="max_size")
            public abstract Builder maxSize(int var1);

            @JsonProperty(value="expire_after_access")
            public abstract Builder expireAfterAccess(long var1);

            @JsonProperty(value="expire_after_access_unit")
            public abstract Builder expireAfterAccessUnit(@Nullable TimeUnit var1);

            @JsonProperty(value="expire_after_write")
            public abstract Builder expireAfterWrite(long var1);

            @JsonProperty(value="expire_after_write_unit")
            public abstract Builder expireAfterWriteUnit(@Nullable TimeUnit var1);

            @JsonProperty(value="ignore_null")
            public abstract Builder ignoreNull(@Nullable Boolean var1);

            @JsonProperty(value="ttl_empty")
            public abstract Builder ttlEmpty(@Nullable Long var1);

            @JsonProperty(value="ttl_empty_unit")
            public abstract Builder ttlEmptyUnit(@Nullable TimeUnit var1);

            public abstract Config build();
        }
    }

    private static class MetricStatsCounter
    implements StatsCounter {
        private final LookupCache cache;

        MetricStatsCounter(LookupCache cache) {
            this.cache = cache;
        }

        public void recordHits(int count) {
            this.cache.incrHitCount(count);
            this.cache.incrTotalCount(count);
        }

        public void recordMisses(int count) {
            this.cache.incrMissCount(count);
            this.cache.incrTotalCount(count);
        }

        public void recordLoadSuccess(long loadTime) {
        }

        public void recordLoadFailure(long loadTime) {
        }

        public void recordEviction(@NonNegative int i, RemovalCause removalCause) {
        }

        public @NonNull CacheStats snapshot() {
            throw new UnsupportedOperationException("snapshots not implemented");
        }
    }

    public static class Descriptor
    extends LookupCache.Descriptor<Config> {
        public Descriptor() {
            super(CaffeineLookupCache.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(CaffeineLookupCache.NAME).maxSize(1000).expireAfterAccess(60L).expireAfterAccessUnit(TimeUnit.SECONDS).expireAfterWrite(0L).ignoreNull(false).build();
        }
    }

    public static interface Factory
    extends LookupCache.Factory {
        public CaffeineLookupCache create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupCacheConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

