/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import org.bson.Document;
import org.graylog2.cluster.ClusterConfigServiceImpl;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.AutoValue_V20170110150100_FixAlertConditionsMigration_MigrationCompleted;
import org.graylog2.migrations.Migration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20170110150100_FixAlertConditionsMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20170110150100_FixAlertConditionsMigration.class);
    private static final String FIELD_ID = "_id";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_ALERT_CONDITIONS = "alert_conditions";
    private static final String FIELD_ALERT_CONDITIONS_ID = "alert_conditions.id";
    private static final String ALERT_CONDITIONS_PARAMETERS_PREFIX = "alert_conditions.$.parameters.";
    private final MongoCollection<Document> collection;
    private final ClusterConfigServiceImpl clusterConfigService;

    @Inject
    public V20170110150100_FixAlertConditionsMigration(MongoConnection mongoConnection, ClusterConfigServiceImpl clusterConfigService) {
        this.collection = mongoConnection.getMongoDatabase().getCollection("streams");
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2017-01-10T15:01:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already done.");
            return;
        }
        ImmutableSet.Builder modifiedStreams = ImmutableSet.builder();
        ImmutableSet.Builder modifiedAlertConditions = ImmutableSet.builder();
        for (Document document : this.collection.find().sort(Sorts.ascending((String[])new String[]{FIELD_CREATED_AT}))) {
            String streamId = document.getObjectId((Object)FIELD_ID).toHexString();
            if (!document.containsKey((Object)FIELD_ALERT_CONDITIONS)) continue;
            List alertConditions = (List)document.get((Object)FIELD_ALERT_CONDITIONS);
            ImmutableSet intFields = ImmutableSet.of((Object)"grace", (Object)"backlog", (Object)"time", (Object)"threshold");
            for (Document alertCondition : alertConditions) {
                String alertConditionId = (String)alertCondition.get((Object)"id", String.class);
                String alertConditionTitle = (String)alertCondition.get((Object)"title", String.class);
                Document parameters = (Document)alertCondition.get((Object)"parameters", Document.class);
                for (String field : intFields) {
                    UpdateResult result;
                    Object fieldValue = parameters.get((Object)field);
                    if (fieldValue == null || fieldValue instanceof Integer) continue;
                    if (!(fieldValue instanceof String)) {
                        LOG.warn("Field <{}> in alert condition <{}> ({}) of stream <{}> is not a string but a <{}>, not trying to convert it!", new Object[]{field, alertConditionId, alertConditionTitle, streamId, fieldValue.getClass().getCanonicalName()});
                        continue;
                    }
                    String stringValue = (String)parameters.get((Object)field, String.class);
                    Integer intValue = Ints.tryParse((String)stringValue);
                    LOG.info("Converting value for field <{}> from string to integer in alert condition <{}> ({}) of stream <{}>", new Object[]{field, alertConditionId, alertConditionTitle, streamId});
                    if (intValue == null) {
                        LOG.error("Unable to parse \"{}\" into integer!", fieldValue);
                    }
                    if ((result = this.collection.updateOne(Filters.eq((String)FIELD_ALERT_CONDITIONS_ID, (Object)alertConditionId), Updates.set((String)(ALERT_CONDITIONS_PARAMETERS_PREFIX + field), (Object)intValue))).getMatchedCount() > 0L) {
                        modifiedStreams.add((Object)streamId);
                        modifiedAlertConditions.add((Object)alertConditionId);
                        continue;
                    }
                    LOG.warn("No document modified for alert condition <{}> ({})", (Object)alertConditionId, (Object)alertConditionTitle);
                }
            }
        }
        this.clusterConfigService.write(MigrationCompleted.create((Set<String>)modifiedStreams.build(), (Set<String>)modifiedAlertConditions.build()));
    }

    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="stream_ids")
        public abstract Set<String> streamIds();

        @JsonProperty(value="alert_condition_ids")
        public abstract Set<String> alertConditionIds();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="stream_ids") Set<String> streamIds, @JsonProperty(value="alert_condition_ids") Set<String> alertConditionIds) {
            return new AutoValue_V20170110150100_FixAlertConditionsMigration_MigrationCompleted(streamIds, alertConditionIds);
        }
    }
}

