/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.graylog.events.legacy.LegacyAlarmCallbackEventNotificationConfig;
import org.graylog.events.notifications.DBNotificationService;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog.events.notifications.NotificationDto;
import org.graylog.events.notifications.types.HTTPEventNotificationConfig;
import org.graylog2.lookup.adapters.DSVHTTPDataAdapter;
import org.graylog2.lookup.adapters.HTTPJSONPathDataAdapter;
import org.graylog2.lookup.db.DBDataAdapterService;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.migrations.AutoValue_V20191129134600_CreateInitialUrlWhitelist_MigrationCompleted;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.system.urlwhitelist.LiteralWhitelistEntry;
import org.graylog2.system.urlwhitelist.RegexHelper;
import org.graylog2.system.urlwhitelist.RegexWhitelistEntry;
import org.graylog2.system.urlwhitelist.UrlWhitelist;
import org.graylog2.system.urlwhitelist.UrlWhitelistService;
import org.graylog2.system.urlwhitelist.WhitelistEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20191129134600_CreateInitialUrlWhitelist
extends Migration {
    private static final Logger log = LoggerFactory.getLogger(V20191129134600_CreateInitialUrlWhitelist.class);
    private final ClusterConfigService configService;
    private final UrlWhitelistService whitelistService;
    private final DBDataAdapterService dataAdapterService;
    private final DBNotificationService notificationService;
    private final RegexHelper regexHelper;

    @Inject
    public V20191129134600_CreateInitialUrlWhitelist(ClusterConfigService clusterConfigService, UrlWhitelistService whitelistService, DBDataAdapterService dataAdapterService, DBNotificationService notificationService, RegexHelper regexHelper) {
        this.configService = clusterConfigService;
        this.whitelistService = whitelistService;
        this.dataAdapterService = dataAdapterService;
        this.notificationService = notificationService;
        this.regexHelper = regexHelper;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2019-11-29T13:46:00Z");
    }

    @Override
    public void upgrade() {
        MigrationCompleted migrationCompleted = this.configService.get(MigrationCompleted.class);
        if (migrationCompleted != null) {
            log.debug("Migration already completed.");
            return;
        }
        UrlWhitelist whitelist = this.createWhitelist();
        this.whitelistService.saveWhitelist(whitelist);
        this.configService.write(MigrationCompleted.create(whitelist.toString()));
    }

    private UrlWhitelist createWhitelist() {
        HashSet entries = new HashSet();
        this.dataAdapterService.findAll().stream().map(this::extractFromDataAdapter).forEach(e -> e.ifPresent(entries::add));
        try (Stream notificationsStream = this.notificationService.streamAll();){
            notificationsStream.map(this::extractFromNotification).forEach(e -> e.ifPresent(entries::add));
        }
        log.info("Created {} whitelist entries from URLs configured in data adapters and event notifications.", (Object)entries.size());
        UrlWhitelist whitelist = UrlWhitelist.createEnabled(new ArrayList<WhitelistEntry>(entries));
        log.debug("Resulting whitelist: {}.", (Object)whitelist);
        return whitelist;
    }

    private Optional<WhitelistEntry> extractFromNotification(NotificationDto notificationDto) {
        EventNotificationConfig config = notificationDto.config();
        String url = "";
        if (config instanceof HTTPEventNotificationConfig) {
            url = ((HTTPEventNotificationConfig)config).url();
        } else if (config instanceof LegacyAlarmCallbackEventNotificationConfig) {
            url = Objects.toString(((LegacyAlarmCallbackEventNotificationConfig)config).configuration().get("url"), "");
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            return this.defaultIfNotMatching(LiteralWhitelistEntry.create(UUID.randomUUID().toString(), "\"" + notificationDto.title() + "\" alert notification", url), url);
        }
        return Optional.empty();
    }

    private Optional<WhitelistEntry> extractFromDataAdapter(DataAdapterDto dataAdapterDto) {
        LookupDataAdapterConfiguration config = dataAdapterDto.config();
        if (config instanceof DSVHTTPDataAdapter.Config) {
            String url = ((DSVHTTPDataAdapter.Config)config).url();
            return this.defaultIfNotMatching(LiteralWhitelistEntry.create(UUID.randomUUID().toString(), "\"" + dataAdapterDto.title() + "\" data adapter", url), url);
        }
        if (config instanceof HTTPJSONPathDataAdapter.Config) {
            String url = StringUtils.strip((String)((HTTPJSONPathDataAdapter.Config)config).url());
            String regex = this.regexHelper.createRegexForUrlTemplate(url, "${key}");
            return this.defaultIfNotMatching(RegexWhitelistEntry.create(UUID.randomUUID().toString(), "\"" + dataAdapterDto.title() + "\" data adapter", regex), url);
        }
        return Optional.empty();
    }

    private Optional<WhitelistEntry> defaultIfNotMatching(WhitelistEntry entry, String url) {
        if (!entry.isWhitelisted(url)) {
            log.error("Unable to create matching URL whitelist entry for URL <{}>. Please configure your URL whitelist manually.", (Object)url);
            return Optional.empty();
        }
        return Optional.of(entry);
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="created_whitelist")
        public abstract String createdWhitelist();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="created_whitelist") String createdWhitelist) {
            return new AutoValue_V20191129134600_CreateInitialUrlWhitelist_MigrationCompleted(createdWhitelist);
        }
    }
}

