/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.Updates;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.List;
import org.bson.Document;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20230904073300_MigrateThemePreferences
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20230904073300_MigrateThemePreferences.class);
    private static final String THEME_MODE_KEY = "preferences.themeMode";
    private final ClusterConfigService configService;
    private final MongoCollection<Document> usersCollections;

    @Inject
    public V20230904073300_MigrateThemePreferences(ClusterConfigService configService, MongoConnection mongoConnection) {
        this.configService = configService;
        this.usersCollections = mongoConnection.getMongoDatabase().getCollection("users");
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-09-04T07:33:00Z");
    }

    @Override
    public void upgrade() {
        if (this.configService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        BulkWriteResult result = this.usersCollections.bulkWrite(List.of(new UpdateManyModel(Filters.eq((String)THEME_MODE_KEY, (Object)"teint"), Updates.set((String)THEME_MODE_KEY, (Object)"light")), new UpdateManyModel(Filters.eq((String)THEME_MODE_KEY, (Object)"noir"), Updates.set((String)THEME_MODE_KEY, (Object)"dark"))));
        if (result.wasAcknowledged()) {
            this.configService.write(new MigrationCompleted(result.getMatchedCount(), result.getModifiedCount()));
        }
    }

    public record MigrationCompleted(long matched, long modified) {
    }
}

