/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.util.Size;
import java.nio.file.Path;
import java.util.Optional;
import org.graylog2.bindings.NamedBindingOverride;
import org.graylog2.configuration.PathConfiguration;
import org.joda.time.Duration;

public class KafkaJournalConfiguration
extends PathConfiguration {
    public static final String MESSAGE_JOURNAL_DIR = "message_journal_dir";
    @Parameter(value="message_journal_dir")
    private Path messageJournalDir;
    @Parameter(value="message_journal_segment_size")
    private Size messageJournalSegmentSize = Size.megabytes((long)100L);
    @Parameter(value="message_journal_segment_age")
    private Duration messageJournalSegmentAge = Duration.standardHours((long)1L);
    @Parameter(value="message_journal_max_size")
    private Size messageJournalMaxSize = Size.gigabytes((long)5L);
    @Parameter(value="message_journal_max_age")
    private Duration messageJournalMaxAge = Duration.standardHours((long)12L);
    @Parameter(value="message_journal_flush_interval")
    private long messageJournalFlushInterval = 1000000L;
    @Parameter(value="message_journal_flush_age")
    private Duration messageJournalFlushAge = Duration.standardMinutes((long)1L);

    @NamedBindingOverride(value="message_journal_dir")
    public Path getMessageJournalDir() {
        return Optional.ofNullable(this.messageJournalDir).orElse(this.getDataDir().resolve("journal"));
    }

    public Size getMessageJournalSegmentSize() {
        return this.messageJournalSegmentSize;
    }

    public Duration getMessageJournalSegmentAge() {
        return this.messageJournalSegmentAge;
    }

    public Duration getMessageJournalMaxAge() {
        return this.messageJournalMaxAge;
    }

    public Size getMessageJournalMaxSize() {
        return this.messageJournalMaxSize;
    }

    public long getMessageJournalFlushInterval() {
        return this.messageJournalFlushInterval;
    }

    public Duration getMessageJournalFlushAge() {
        return this.messageJournalFlushAge;
    }
}

