/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inputs.transports;

import com.codahale.metrics.MetricSet;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.Service;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.MisfireException;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.inputs.transports.ThrottleableTransport;
import org.graylog2.plugin.journal.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneratorTransport
extends ThrottleableTransport {
    private static final Logger log = LoggerFactory.getLogger(GeneratorTransport.class);
    private Service generatorService;

    public GeneratorTransport(EventBus eventBus, Configuration configuration) {
        super(eventBus, configuration);
    }

    @Override
    public void setMessageAggregator(CodecAggregator aggregator) {
    }

    protected abstract RawMessage produceRawMessage(MessageInput var1);

    @Override
    public void doLaunch(final MessageInput input) throws MisfireException {
        this.generatorService = new AbstractExecutionThreadService(){
            Thread runThread;

            protected void run() throws Exception {
                while (this.isRunning()) {
                    RawMessage rawMessage;
                    if (GeneratorTransport.this.isThrottled()) {
                        GeneratorTransport.this.blockUntilUnthrottled();
                    }
                    if ((rawMessage = GeneratorTransport.this.produceRawMessage(input)) == null) continue;
                    input.processRawMessage(rawMessage);
                }
            }

            protected void startUp() throws Exception {
                this.runThread = Thread.currentThread();
            }

            protected void triggerShutdown() {
                this.runThread.interrupt();
            }
        };
        this.generatorService.startAsync();
    }

    @Override
    public void doStop() {
        if (this.generatorService == null || !this.generatorService.isRunning()) {
            log.error("Cannot stop generator transport, it isn't running.");
            return;
        }
        log.debug("Stopping generator transport service {}", (Object)this.generatorService);
        this.generatorService.stopAsync().awaitTerminated();
        this.generatorService = null;
    }

    @Override
    public MetricSet getMetricSet() {
        return null;
    }

    public static class Config
    extends ThrottleableTransport.Config {
    }
}

