/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest;

import com.floreysoft.jmte.Engine;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringEscapeUtils;
import org.glassfish.grizzly.http.server.ErrorPageGenerator;
import org.glassfish.grizzly.http.server.Request;

public class GraylogErrorPageGenerator
implements ErrorPageGenerator {
    private final String template;
    private final Engine engine;

    @Inject
    public GraylogErrorPageGenerator(Engine templateEngine) throws IOException {
        this(Resources.toString((URL)Resources.getResource((String)"error.html.template"), (Charset)StandardCharsets.UTF_8), templateEngine);
    }

    private GraylogErrorPageGenerator(String template, Engine templateEngine) {
        this.template = Objects.requireNonNull(template, "template");
        this.engine = Objects.requireNonNull(templateEngine, "templateEngine");
    }

    public String generate(Request request, int status, String reasonPhrase, String description, Throwable exception) {
        ImmutableMap.Builder modelBuilder = ImmutableMap.builder();
        modelBuilder.put((Object)"reason", (Object)StringEscapeUtils.escapeHtml4((String)reasonPhrase));
        if (description != null) {
            modelBuilder.put((Object)"description", (Object)StringEscapeUtils.escapeHtml4((String)description));
        }
        if (exception != null) {
            String exceptionString = Objects.nonNull(exception.getMessage()) ? exception.getMessage() : "Null";
            modelBuilder.put((Object)"exception", (Object)StringEscapeUtils.escapeHtml4((String)exceptionString));
        }
        return this.engine.transform(this.template, (Map)modelBuilder.build());
    }
}

