/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest;

import com.google.common.base.Strings;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import okhttp3.ResponseBody;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.jersey.server.model.Resource;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.graylog2.shared.security.ShiroPrincipal;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.graylog2.utilities.IpSubnet;

public class RestTools {
    @Nullable
    public static String getUserIdFromRequest(ContainerRequestContext requestContext) {
        SecurityContext securityContext = requestContext.getSecurityContext();
        if (!(securityContext instanceof ShiroSecurityContext)) {
            return null;
        }
        ShiroSecurityContext shiroSecurityContext = (ShiroSecurityContext)securityContext;
        Principal userPrincipal = shiroSecurityContext.getUserPrincipal();
        if (!(userPrincipal instanceof ShiroPrincipal)) {
            return null;
        }
        ShiroPrincipal shiroPrincipal = (ShiroPrincipal)userPrincipal;
        return shiroPrincipal.getName();
    }

    public static String getRemoteAddrFromRequest(Request request, Set<IpSubnet> trustedSubnets) {
        String remoteAddr = request.getRemoteAddr();
        String XForwardedFor = request.getHeader("X-Forwarded-For");
        if (XForwardedFor != null) {
            for (IpSubnet s : trustedSubnets) {
                try {
                    if (!s.contains(remoteAddr)) continue;
                    return XForwardedFor;
                }
                catch (UnknownHostException unknownHostException) {
                }
            }
        }
        return remoteAddr;
    }

    public static URI buildExternalUri(@NotNull MultivaluedMap<String, String> httpHeaders, @NotNull URI defaultUri) {
        URI uri;
        Optional<URI> externalUri = Optional.empty();
        List headers = (List)httpHeaders.get((Object)"X-Graylog-Server-URL");
        if (headers != null && !headers.isEmpty()) {
            externalUri = headers.stream().filter(s -> {
                try {
                    if (Strings.isNullOrEmpty((String)s)) {
                        return false;
                    }
                    URI uri = new URI((String)s);
                    if (!uri.isAbsolute()) {
                        return true;
                    }
                    switch (uri.getScheme()) {
                        case "http": 
                        case "https": {
                            return true;
                        }
                    }
                    return false;
                }
                catch (URISyntaxException e) {
                    return false;
                }
            }).map(URI::create).findFirst();
        }
        if (!(uri = externalUri.orElse(defaultUri)).toString().endsWith("/")) {
            return URI.create(uri.toString() + "/");
        }
        return uri;
    }

    public static URI buildRelativeExternalUri(@NotNull MultivaluedMap<String, String> httpHeaders, @NotNull URI defaultUri) {
        URI externalUri = RestTools.buildExternalUri(httpHeaders, defaultUri);
        return URI.create(externalUri.getPath());
    }

    public static String getPathFromResource(Resource resource) {
        Object path = resource.getPath();
        for (Resource parent = resource.getParent(); parent != null; parent = parent.getParent()) {
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            path = parent.getPath() + (String)path;
        }
        return path;
    }

    public static Response.ResponseBuilder respondWithFile(String filename, Object entity) {
        return Response.ok((Object)entity).header("Content-Disposition", (Object)("attachment; filename=" + filename));
    }

    public static Response.ResponseBuilder respondWithFile(String filename, Object entity, MediaType mediaType) {
        return RestTools.respondWithFile(filename, entity).type(mediaType);
    }

    public static Response.ResponseBuilder respondWithFile(String filename, Object entity, MediaType mediaType, long size) {
        return RestTools.respondWithFile(filename, entity, mediaType).header("Content-Length", (Object)size);
    }

    public static Response streamResponse(ProxiedResource.NodeResponse<ResponseBody> nodeResponse, String mediaType, Consumer<Response.ResponseBuilder> additionalResponseBuildingOnSuccess) {
        if (nodeResponse.isSuccess()) {
            ResponseBody responseBody = nodeResponse.entity().orElseThrow();
            try {
                Response.ResponseBuilder responseBuilder = Response.ok().type(MediaType.valueOf((String)mediaType)).entity((Object)responseBody.byteStream());
                if (additionalResponseBuildingOnSuccess != null) {
                    additionalResponseBuildingOnSuccess.accept(responseBuilder);
                }
                return responseBuilder.build();
            }
            catch (Exception e) {
                responseBody.close();
            }
        }
        return Response.status((int)nodeResponse.code()).entity(nodeResponse.body()).build();
    }
}

