/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import java.net.URI;
import java.util.Date;
import java.util.Optional;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.rest.RestTools;
import org.graylog2.rest.models.system.sessions.responses.SessionResponse;

@Singleton
public class CookieFactory {
    private static final String HEADER_ORIGIN = "Origin";
    private static final String HEADER_X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private static final CharMatcher PATH_MATCHER = CharMatcher.ascii().and(CharMatcher.isNot((char)';')).and(CharMatcher.javaIsoControl().negate());
    private final URI httpExternalUri;
    private final boolean httpCookieSecureOverride;
    private final boolean httpCookieSameSiteStrict;

    @Inject
    public CookieFactory(HttpConfiguration httpConfiguration) {
        this.httpExternalUri = httpConfiguration.getHttpExternalUri();
        this.httpCookieSecureOverride = httpConfiguration.getHttpCookieSecureOverride();
        this.httpCookieSameSiteStrict = httpConfiguration.getHttpCookieSameSiteStrict();
    }

    NewCookie createAuthenticationCookie(SessionResponse token, ContainerRequestContext requestContext) {
        return this.makeCookie(token.getAuthenticationToken(), token.validUntil(), requestContext);
    }

    NewCookie deleteAuthenticationCookie(ContainerRequestContext requestContext) {
        return this.makeCookie("", new Date(), requestContext);
    }

    private NewCookie makeCookie(String value, Date validUntil, ContainerRequestContext requestContext) {
        Date now = new Date();
        int maxAge = Long.valueOf((validUntil.getTime() - now.getTime()) / 1000L).intValue();
        String basePath = this.cookiePathFromRequest(requestContext);
        boolean isSecure = this.schemeFromRequest(requestContext).map(scheme -> scheme.equalsIgnoreCase("https")).orElse(false);
        return ((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder("authentication").value(value)).comment("Authentication Cookie")).path(basePath)).maxAge(maxAge)).expiry(validUntil)).secure(isSecure || this.httpCookieSecureOverride)).httpOnly(true)).sameSite(this.httpCookieSameSiteStrict ? NewCookie.SameSite.STRICT : NewCookie.SameSite.NONE)).build();
    }

    private Optional<String> schemeFromRequest(ContainerRequestContext requestContext) {
        Optional<URI> graylogUrlFromHeader = this.uriFromHeader(requestContext, "X-Graylog-Server-URL");
        if (graylogUrlFromHeader.isPresent()) {
            return graylogUrlFromHeader.map(URI::getScheme);
        }
        Optional<String> xForwardedProtoHeader = Optional.ofNullable(requestContext.getHeaderString(HEADER_X_FORWARDED_PROTO)).filter(header -> !Strings.isNullOrEmpty((String)header));
        if (xForwardedProtoHeader.isPresent()) {
            return xForwardedProtoHeader;
        }
        Optional<URI> origin = this.uriFromHeader(requestContext, HEADER_ORIGIN);
        return origin.map(URI::getScheme);
    }

    private Optional<URI> uriFromHeader(ContainerRequestContext requestContext, String headerName) {
        return Optional.ofNullable(requestContext.getHeaderString(headerName)).filter(header -> !Strings.isNullOrEmpty((String)header)).flatMap(this::safeCreateUri);
    }

    private String cookiePathFromRequest(ContainerRequestContext requestContext) {
        return this.sanitizePath(RestTools.buildExternalUri((MultivaluedMap<String, String>)requestContext.getHeaders(), this.httpExternalUri).getPath());
    }

    private Optional<URI> safeCreateUri(String uri) {
        try {
            return Optional.of(URI.create(uri));
        }
        catch (IllegalArgumentException ignored) {
            return Optional.empty();
        }
    }

    private String sanitizePath(String path) {
        return PATH_MATCHER.retainFrom((CharSequence)path);
    }
}

