/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.contentpacks;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.Set;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.contentpacks.ContentPackService;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.rest.models.system.contentpacks.responses.CatalogIndexResponse;
import org.graylog2.rest.models.system.contentpacks.responses.CatalogResolveRequest;
import org.graylog2.rest.models.system.contentpacks.responses.CatalogResolveResponse;
import org.graylog2.rest.resources.system.contentpacks.titles.EntityTitleService;
import org.graylog2.rest.resources.system.contentpacks.titles.model.EntitiesTitleResponse;
import org.graylog2.rest.resources.system.contentpacks.titles.model.EntityTitleRequest;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/Catalog", description="Entity Catalog")
@Path(value="/system/catalog")
@Produces(value={"application/json"})
public class CatalogResource
extends RestResource {
    private final ContentPackService contentPackService;
    private final EntityTitleService entityTitleService;

    @Inject
    public CatalogResource(ContentPackService contentPackService, EntityTitleService entityTitleService) {
        this.contentPackService = contentPackService;
        this.entityTitleService = entityTitleService;
    }

    @GET
    @Timed
    @ApiOperation(value="List available entities in this Graylog cluster")
    @RequiresPermissions(value={"catalog:list"})
    public CatalogIndexResponse showEntityIndex() {
        Set<EntityExcerpt> entities = this.contentPackService.listAllEntityExcerpts();
        return CatalogIndexResponse.create(entities);
    }

    @POST
    @Timed
    @ApiOperation(value="Resolve dependencies of entities and return their configuration")
    @RequiresPermissions(value={"catalog:resolve"})
    @NoAuditEvent(value="this is not changing any data")
    public CatalogResolveResponse resolveEntities(@ApiParam(name="JSON body", required=true) @Valid @NotNull CatalogResolveRequest request) {
        ImmutableSet<EntityDescriptor> requestedEntities = request.entities();
        Set<EntityDescriptor> resolvedEntities = this.contentPackService.resolveEntities((Collection<EntityDescriptor>)requestedEntities);
        ImmutableSet<Entity> entities = this.contentPackService.collectEntities(resolvedEntities);
        return CatalogResolveResponse.create(entities);
    }

    @POST
    @Timed
    @ApiOperation(value="Get titles of provided entities")
    @NoAuditEvent(value="This endpoint does not change any data")
    @Consumes(value={"application/json"})
    @Path(value="/entities/titles")
    public EntitiesTitleResponse getTitles(@ApiParam(name="JSON body", required=true) EntityTitleRequest request, @Context SearchUser searchUser) {
        return this.entityTitleService.getTitles(request, searchUser);
    }
}

