/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.debug.bundle;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.Optional;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.rest.RestTools;
import org.graylog2.rest.resources.system.debug.bundle.BundleFile;
import org.graylog2.rest.resources.system.debug.bundle.LogFile;
import org.graylog2.rest.resources.system.debug.bundle.SupportBundleNodeManifest;
import org.graylog2.rest.resources.system.debug.bundle.SupportBundleService;
import org.graylog2.shared.rest.HideOnCloud;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.security.RestrictToLeader;
import org.graylog2.shared.utilities.StringUtils;

@RequiresAuthentication
@Api(value="System/Debug/SupportBundle", description="For collecting debugging information, e.g. server logs")
@Path(value="/system/debug/support")
@Produces(value={"application/json"})
@HideOnCloud
public class SupportBundleResource
extends RestResource {
    private final SupportBundleService supportBundleService;

    @Inject
    public SupportBundleResource(SupportBundleService supportBundleService) {
        this.supportBundleService = supportBundleService;
    }

    @GET
    @Path(value="/manifest")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a nodes' Support Bundle Manifest")
    @RequiresPermissions(value={"supportbundle:read"})
    public SupportBundleNodeManifest getNodeManifest() {
        return this.supportBundleService.getManifest();
    }

    @GET
    @Path(value="/logfile/{id}")
    @ApiOperation(value="Retrieve the nodes' server logfile")
    @RequiresPermissions(value={"supportbundle:read"})
    @Produces(value={"application/octet-stream"})
    public Response getLogFile(@PathParam(value="id") @ApiParam(name="id", value="The id of the logfile as referenced from the Support Bundle Manifest") String id) {
        Optional<LogFile> logFileOptional = this.supportBundleService.getManifest().entries().logfiles().stream().filter(l -> l.id().equals(id)).findFirst();
        LogFile logFile = logFileOptional.orElseThrow(() -> new NotFoundException(StringUtils.f("No logfile found for id <%s>", id)));
        MediaType mediaType = MediaType.valueOf((String)"application/octet-stream");
        StreamingOutput streamingOutput = outputStream -> this.supportBundleService.loadLogFileStream(logFile, outputStream);
        return RestTools.respondWithFile(logFile.name(), streamingOutput, mediaType, logFile.size()).build();
    }

    @POST
    @Path(value="/bundle/build")
    @Timed
    @RestrictToLeader
    @RequiresPermissions(value={"supportbundle:create"})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:support_bundle:create")
    public Response buildBundle(@Context HttpHeaders httpHeaders) {
        this.supportBundleService.buildBundle(httpHeaders, this.getSubject());
        return Response.accepted().build();
    }

    @GET
    @Path(value="/bundle/list")
    @ApiOperation(value="Returns the list of downloadable support bundles")
    @RequiresPermissions(value={"supportbundle:read"})
    @RestrictToLeader
    public List<BundleFile> listBundles() {
        return this.supportBundleService.listBundles();
    }

    @GET
    @Path(value="/bundle/download/{filename}")
    @ApiOperation(value="Downloads the requested bundle")
    @RequiresPermissions(value={"supportbundle:read"})
    @RestrictToLeader
    @Produces(value={"application/octet-stream"})
    @AuditEvent(type="server:support_bundle:download")
    public Response download(@PathParam(value="filename") @ApiParam(value="filename") String filename) {
        MediaType mediaType = MediaType.valueOf((String)"application/octet-stream");
        StreamingOutput streamingOutput = outputStream -> this.supportBundleService.downloadBundle(filename, outputStream);
        return RestTools.respondWithFile(filename, streamingOutput, mediaType).build();
    }

    @DELETE
    @Path(value="/bundle/{filename}")
    @ApiOperation(value="Delete a certain support bundle")
    @RequiresPermissions(value={"supportbundle:create"})
    @RestrictToLeader
    @AuditEvent(type="server:support_bundle:delete")
    public Response delete(@PathParam(value="filename") @ApiParam(value="filename") String filename) throws IOException {
        try {
            this.supportBundleService.deleteBundle(filename);
        }
        catch (NoSuchFileException e) {
            throw new NotFoundException((Throwable)e);
        }
        return Response.accepted().build();
    }
}

