/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.indexer.IndexFailure;
import org.graylog2.indexer.IndexFailureService;
import org.graylog2.rest.models.system.indexer.responses.FailureCount;
import org.graylog2.shared.rest.resources.RestResource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Indexer/Failures", description="Indexer failures")
@Path(value="/system/indexer/failures")
public class FailuresResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(FailuresResource.class);
    private IndexFailureService indexFailureService;

    @Inject
    public FailuresResource(IndexFailureService indexFailureService) {
        this.indexFailureService = indexFailureService;
    }

    @GET
    @Timed
    @ApiOperation(value="Total count of failed index operations since the given date.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid date parameter provided.")})
    @RequiresPermissions(value={"indices:failures"})
    @Produces(value={"application/json"})
    @Path(value="count")
    public FailureCount count(@ApiParam(name="since", value="ISO8601 date", required=true) @QueryParam(value="since") @NotEmpty String since) {
        DateTime sinceDate;
        try {
            sinceDate = DateTime.parse((String)since);
        }
        catch (IllegalArgumentException e) {
            String msg = "Invalid date parameter provided: [" + since + "]";
            LOG.error(msg, (Throwable)e);
            throw new BadRequestException(msg);
        }
        return FailureCount.create(this.indexFailureService.countSince(sinceDate));
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of failed index operations.")
    @RequiresPermissions(value={"indices:failures"})
    @Produces(value={"application/json"})
    public Map<String, Object> single(@ApiParam(name="limit", value="Limit", required=true) @QueryParam(value="limit") @Min(value=0L) @Min(value=0L) int limit, @ApiParam(name="offset", value="Offset", required=true) @QueryParam(value="offset") @Min(value=0L) @Min(value=0L) int offset) {
        List<IndexFailure> indexFailures = this.indexFailureService.all(limit, offset);
        ArrayList<Map<String, Object>> failures = new ArrayList<Map<String, Object>>(indexFailures.size());
        for (IndexFailure failure : indexFailures) {
            failures.add(failure.asMap());
        }
        return ImmutableMap.of((Object)"failures", failures, (Object)"total", (Object)this.indexFailureService.totalCount());
    }
}

