/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.database.filtering.inmemory.InMemoryFilterable;
import org.graylog2.indexer.indexset.CustomFieldMappings;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.rest.resources.entities.EntityDefaults;
import org.graylog2.rest.resources.entities.FilterOption;
import org.graylog2.rest.resources.entities.Sorting;
import org.graylog2.rest.resources.system.indexer.responses.FieldTypeOrigin;
import org.graylog2.search.SearchQueryField;

public record IndexSetFieldType(@JsonProperty(value="field_name") String fieldName, @JsonProperty(value="type") String type, @JsonProperty(value="origin") FieldTypeOrigin origin, @JsonProperty(value="is_reserved") boolean isReserved) implements InMemoryFilterable
{
    static final String FIELD_NAME = "field_name";
    static final String TYPE = "type";
    static final String ORIGIN = "origin";
    static final String IS_RESERVED = "is_reserved";
    public static final String DEFAULT_SORT_FIELD = "field_name";
    public static final Sorting DEFAULT_SORT = Sorting.create("field_name", Sorting.Direction.ASC);
    public static final EntityDefaults ENTITY_DEFAULTS = EntityDefaults.builder().sort(DEFAULT_SORT).build();
    public static final List<EntityAttribute> ATTRIBUTES = List.of(EntityAttribute.builder().id("field_name").title("Field name").sortable(true).filterable(true).build(), EntityAttribute.builder().id("origin").title("Origin").type(SearchQueryField.Type.STRING).sortable(true).filterable(true).filterOptions(Arrays.stream(FieldTypeOrigin.values()).map(origin -> FilterOption.create(origin.toString(), origin.title())).collect(Collectors.toSet())).build(), EntityAttribute.builder().id("is_reserved").title("Is Reserved").type(SearchQueryField.Type.BOOLEAN).sortable(true).filterable(true).filterOptions(Set.of(FilterOption.create("true", "yes"), FilterOption.create("false", "no"))).build(), EntityAttribute.builder().id("type").title("Type").sortable(true).filterable(true).filterOptions(CustomFieldMappings.AVAILABLE_TYPES.entrySet().stream().map(entry -> FilterOption.create((String)entry.getKey(), ((CustomFieldMappings.TypeDescription)entry.getValue()).description())).collect(Collectors.toSet())).build());

    @Override
    public Optional<Object> extractFieldValue(String fieldName) {
        return switch (fieldName) {
            case "field_name" -> Optional.ofNullable(this.fieldName());
            case TYPE -> Optional.ofNullable(this.type());
            case ORIGIN -> Optional.of(this.origin()).map(o -> o.toString());
            case IS_RESERVED -> Optional.of(this.isReserved());
            default -> Optional.empty();
        };
    }

    public static Comparator<IndexSetFieldType> getComparator(String sort, Sorting.Direction order) {
        Comparator<IndexSetFieldType> comparator;
        switch (sort) {
            case "type": {
                Comparator<IndexSetFieldType> comparator2 = Comparator.comparing(IndexSetFieldType::type);
                break;
            }
            case "is_reserved": {
                Comparator<IndexSetFieldType> comparator2 = Comparator.comparing(IndexSetFieldType::isReserved);
                break;
            }
            case "origin": {
                Comparator<IndexSetFieldType> comparator2 = Comparator.comparing(IndexSetFieldType::origin);
                break;
            }
            default: {
                Comparator<IndexSetFieldType> comparator2 = comparator = Comparator.comparing(IndexSetFieldType::fieldName);
            }
        }
        if (order == Sorting.Direction.DESC) {
            return comparator.reversed();
        }
        return comparator;
    }
}

