/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Collections;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.ConfigurationException;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.inputs.extractors.RegexReplaceExtractor;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.rest.models.tools.requests.RegexReplaceTestRequest;
import org.graylog2.rest.models.tools.responses.RegexReplaceTesterResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/tools/regex_replace_tester")
public class RegexReplaceTesterResource
extends RestResource {
    @GET
    @Timed
    @Produces(value={"application/json"})
    public RegexReplaceTesterResponse regexTester(@QueryParam(value="regex") @NotEmpty String regex, @QueryParam(value="replacement") @NotNull String replacement, @QueryParam(value="replace_all") @DefaultValue(value="false") boolean replaceAll, @QueryParam(value="string") @NotNull String string) {
        return this.testRegexReplaceExtractor(string, regex, replacement, replaceAll);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoAuditEvent(value="only used to test regex replace extractor")
    public RegexReplaceTesterResponse testRegex(@Valid @NotNull RegexReplaceTestRequest r) {
        return this.testRegexReplaceExtractor(r.string(), r.regex(), r.replacement(), r.replaceAll());
    }

    private RegexReplaceTesterResponse testRegexReplaceExtractor(String example, String regex, String replacement, boolean replaceAll) {
        RegexReplaceExtractor extractor;
        ImmutableMap config = ImmutableMap.of((Object)"regex", (Object)regex, (Object)"replacement", (Object)replacement, (Object)"replace_all", (Object)replaceAll);
        try {
            extractor = new RegexReplaceExtractor(new MetricRegistry(), "test", "Test", 0L, Extractor.CursorStrategy.COPY, "test", "test", (Map<String, Object>)config, this.getCurrentUser().getName(), Collections.emptyList(), Extractor.ConditionType.NONE, "");
        }
        catch (Extractor.ReservedFieldException e) {
            throw new BadRequestException("Trying to overwrite a reserved message field", (Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new BadRequestException("Invalid extractor configuration", (Throwable)e);
        }
        Extractor.Result result = extractor.runExtractor(example);
        RegexReplaceTesterResponse.Match match = result == null ? null : RegexReplaceTesterResponse.Match.create(String.valueOf(result.getValue()), result.getBeginIndex(), result.getEndIndex());
        return RegexReplaceTesterResponse.create(result != null, match, regex, replacement, replaceAll, example);
    }
}

