/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

@Singleton
public class TrustManagerAndSocketFactoryProvider {
    private final SSLSocketFactory sslSocketFactory;
    private final X509TrustManager trustManager;
    private final SSLContext sslContext = SSLContext.getInstance("TLS");

    @Inject
    public TrustManagerAndSocketFactoryProvider(X509TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        this.trustManager = trustManager;
        this.sslContext.init(null, new TrustManager[]{this.trustManager}, new SecureRandom());
        this.sslSocketFactory = this.sslContext.getSocketFactory();
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }
}

