/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings.providers;

import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.graylog2.security.TrustManagerAndSocketFactoryProvider;
import org.graylog2.shared.bindings.providers.ProxySelectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OkHttpClientProvider
implements Provider<OkHttpClient> {
    private static final Logger LOG = LoggerFactory.getLogger(OkHttpClientProvider.class);
    protected final Duration connectTimeout;
    protected final Duration readTimeout;
    protected final Duration writeTimeout;
    protected final URI httpProxyUri;
    private final TrustManagerAndSocketFactoryProvider trustManagerAndSocketFactoryProvider;
    private final ProxySelectorProvider proxySelectorProvider;

    @Inject
    public OkHttpClientProvider(@Named(value="http_connect_timeout") Duration connectTimeout, @Named(value="http_read_timeout") Duration readTimeout, @Named(value="http_write_timeout") Duration writeTimeout, @Named(value="http_proxy_uri") @Nullable URI httpProxyUri, TrustManagerAndSocketFactoryProvider trustManagerAndSocketFactoryProvider, ProxySelectorProvider proxySelectorProvider) {
        this.connectTimeout = Objects.requireNonNull(connectTimeout);
        this.readTimeout = Objects.requireNonNull(readTimeout);
        this.writeTimeout = Objects.requireNonNull(writeTimeout);
        this.httpProxyUri = httpProxyUri;
        this.trustManagerAndSocketFactoryProvider = trustManagerAndSocketFactoryProvider;
        this.proxySelectorProvider = proxySelectorProvider;
    }

    public OkHttpClient get() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().retryOnConnectionFailure(true).connectTimeout(this.connectTimeout.getQuantity(), this.connectTimeout.getUnit()).writeTimeout(this.writeTimeout.getQuantity(), this.writeTimeout.getUnit()).readTimeout(this.readTimeout.getQuantity(), this.readTimeout.getUnit());
        if (this.trustManagerAndSocketFactoryProvider != null) {
            clientBuilder.sslSocketFactory(this.trustManagerAndSocketFactoryProvider.getSslSocketFactory(), this.trustManagerAndSocketFactoryProvider.getTrustManager());
        }
        if (this.httpProxyUri != null) {
            List list;
            clientBuilder.proxySelector(this.proxySelectorProvider.get());
            if (!Strings.isNullOrEmpty((String)this.httpProxyUri.getUserInfo()) && (list = Splitter.on((String)":").limit(2).splitToList((CharSequence)this.httpProxyUri.getUserInfo())).size() == 2) {
                clientBuilder.proxyAuthenticator((Authenticator)new ProxyAuthenticator((String)list.get(0), (String)list.get(1)));
            }
        }
        return clientBuilder.build();
    }

    public static class ProxyAuthenticator
    implements Authenticator {
        private static final Logger LOG = LoggerFactory.getLogger(ProxyAuthenticator.class);
        private static final String AUTH_BASIC = "basic";
        private final String credentials;

        ProxyAuthenticator(String user, String password) {
            this.credentials = Credentials.basic((String)Objects.requireNonNull(user, "user"), (String)Objects.requireNonNull(password, "password"));
        }

        @Nullable
        public Request authenticate(@Nonnull Route route, @Nonnull Response response) throws IOException {
            Set authenticationMethods = response.challenges().stream().map(Challenge::scheme).map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            if (!authenticationMethods.contains(AUTH_BASIC)) {
                LOG.warn("Graylog only supports the \"{}\" authentication scheme but the proxy server asks for one of the following: {}", (Object)AUTH_BASIC, authenticationMethods);
                return null;
            }
            if (response.request().header("Proxy-Authorization") != null) {
                return null;
            }
            return response.request().newBuilder().addHeader("Proxy-Authorization", this.credentials).build();
        }
    }
}

