/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings.providers;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import javax.annotation.Nullable;
import org.graylog2.utilities.ProxyHostsPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySelectorProvider
implements Provider<ProxySelector> {
    private static final Logger LOG = LoggerFactory.getLogger(ProxySelectorProvider.class);
    protected final URI httpProxyUri;
    protected final ProxyHostsPattern nonProxyHostsPattern;

    @Inject
    public ProxySelectorProvider(@Named(value="http_proxy_uri") @Nullable URI httpProxyUri, @Named(value="http_non_proxy_hosts") @Nullable ProxyHostsPattern nonProxyHostsPattern) {
        this.httpProxyUri = httpProxyUri;
        this.nonProxyHostsPattern = nonProxyHostsPattern;
    }

    public ProxySelector get() {
        if (this.httpProxyUri == null) {
            return ProxySelector.getDefault();
        }
        return new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                String host = uri.getHost();
                if (ProxySelectorProvider.this.nonProxyHostsPattern != null && ProxySelectorProvider.this.nonProxyHostsPattern.matches(host)) {
                    LOG.debug("Bypassing proxy server for {}", (Object)host);
                    return ImmutableList.of((Object)Proxy.NO_PROXY);
                }
                try {
                    InetAddress targetAddress = InetAddress.getByName(host);
                    if (targetAddress.isLoopbackAddress()) {
                        return ImmutableList.of((Object)Proxy.NO_PROXY);
                    }
                    if (ProxySelectorProvider.this.nonProxyHostsPattern != null && ProxySelectorProvider.this.nonProxyHostsPattern.matches(targetAddress.getHostAddress())) {
                        LOG.debug("Bypassing proxy server for {}", (Object)targetAddress.getHostAddress());
                        return ImmutableList.of((Object)Proxy.NO_PROXY);
                    }
                }
                catch (UnknownHostException e) {
                    LOG.debug("Unable to resolve host name for proxy selection: ", (Throwable)e);
                }
                Proxy proxy = new Proxy(Proxy.Type.HTTP, ProxySelectorProvider.this.getProxyAddress());
                return ImmutableList.of((Object)proxy);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                LOG.warn("Unable to connect to proxy: ", (Throwable)ioe);
            }
        };
    }

    public InetSocketAddress getProxyAddress() {
        return new InetSocketAddress(this.httpProxyUri.getHost(), this.httpProxyUri.getPort());
    }
}

