/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.graylog2.bindings.providers.DefaultStreamProvider;
import org.graylog2.streams.StreamService;
import org.graylog2.streams.events.StreamsChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultStreamChangeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStreamChangeHandler.class);
    private final StreamService streamService;
    private final DefaultStreamProvider defaultStreamProvider;

    @Inject
    public DefaultStreamChangeHandler(StreamService streamService, DefaultStreamProvider defaultStreamProvider, EventBus eventBus) {
        this.streamService = streamService;
        this.defaultStreamProvider = defaultStreamProvider;
        eventBus.register((Object)this);
    }

    @Subscribe
    public void handleStreamsChange(StreamsChangedEvent event) {
        event.streamIds().stream().filter("000000000000000000000001"::equals).findFirst().ifPresent(streamId -> this.reloadDefaultStream());
    }

    private void reloadDefaultStream() {
        try {
            LOG.debug("Attempting to reload and set default stream");
            this.defaultStreamProvider.setDefaultStream(this.streamService.load("000000000000000000000001"));
        }
        catch (Exception e) {
            LOG.error("Couldn't reload default stream", (Throwable)e);
        }
    }
}

