/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.users;

import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.grn.GRNRegistry;
import org.graylog.grn.GRNTypes;
import org.graylog.security.DBGrantService;
import org.graylog.security.GrantDTO;
import org.graylog2.users.PaginatedUserService;
import org.graylog2.users.events.UserDeletedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GrantsCleanupListener {
    private static final Logger log = LoggerFactory.getLogger(GrantsCleanupListener.class);
    private final DBGrantService grantService;
    private final PaginatedUserService userService;
    private final GRNRegistry grnRegistry;

    @Inject
    public GrantsCleanupListener(EventBus eventBus, DBGrantService grantService, PaginatedUserService userService, GRNRegistry grnRegistry) {
        this.grantService = grantService;
        this.userService = userService;
        this.grnRegistry = grnRegistry;
        eventBus.register((Object)this);
    }

    @Subscribe
    public void handleUserDeletedEvent(UserDeletedEvent event) {
        Set users;
        Set grantees;
        try (Stream grantStream = this.grantService.streamAll();){
            grantees = grantStream.map(GrantDTO::grantee).filter(grantee -> grantee.grnType().equals(GRNTypes.USER)).collect(Collectors.toSet());
        }
        try (Stream userStream = this.userService.streamAll();){
            users = userStream.map(user -> this.grnRegistry.newGRN(GRNTypes.USER.type(), user.id())).collect(Collectors.toSet());
        }
        Sets.SetView removedGrantees = Sets.difference(grantees, users);
        if (!removedGrantees.isEmpty()) {
            log.debug("Clearing grants for {} grantees ({}).", (Object)removedGrantees.size(), (Object)removedGrantees);
            removedGrantees.forEach(this.grantService::deleteForGrantee);
        }
    }
}

