/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.users;

import com.google.common.eventbus.EventBus;
import jakarta.inject.Inject;
import org.graylog.grn.GRNRegistry;
import org.graylog.security.PermissionAndRoleResolver;
import org.graylog2.Configuration;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.AccessTokenService;
import org.graylog2.security.InMemoryRolePermissionResolver;
import org.graylog2.shared.users.ChangeUserRequest;
import org.graylog2.shared.users.UserManagementService;
import org.graylog2.users.RoleService;
import org.graylog2.users.UserImpl;
import org.graylog2.users.UserServiceImpl;

public class UserManagementServiceImpl
extends UserServiceImpl
implements UserManagementService {
    @Inject
    public UserManagementServiceImpl(MongoConnection mongoConnection, Configuration configuration, RoleService roleService, AccessTokenService accessTokenService, UserImpl.Factory userFactory, InMemoryRolePermissionResolver inMemoryRolePermissionResolver, EventBus serverEventBus, GRNRegistry grnRegistry, PermissionAndRoleResolver permissionAndRoleResolver) {
        super(mongoConnection, configuration, roleService, accessTokenService, userFactory, inMemoryRolePermissionResolver, serverEventBus, grnRegistry, permissionAndRoleResolver);
    }

    @Override
    public String create(User user) throws ValidationException {
        return super.save(user);
    }

    @Override
    public String update(User user, ChangeUserRequest cr) throws ValidationException {
        return super.save(user);
    }

    @Override
    public void setUserStatus(User user, User.AccountStatus status) throws ValidationException {
        user.setAccountStatus(status);
        super.save(user);
    }

    @Override
    public boolean isUserPassword(User user, String password) {
        return user.isUserPassword(password);
    }

    @Override
    public void changePassword(User user, String oldPassword, String newPassword) throws ValidationException {
        this.changePassword(user, newPassword);
    }

    @Override
    public void changePassword(User user, String newPassword) throws ValidationException {
        user.setPassword(newPassword);
        super.save(user);
    }
}

