/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.web;

import com.google.common.base.Suppliers;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.function.Supplier;
import org.graylog2.web.DevelopmentIndexHtmlGenerator;
import org.graylog2.web.IndexHtmlGenerator;
import org.graylog2.web.ProductionIndexHtmlGenerator;

@Singleton
public class IndexHtmlGeneratorProvider
implements Provider<IndexHtmlGenerator> {
    private final Supplier<IndexHtmlGenerator> indexHtmlGeneratorSupplier;

    @Inject
    public IndexHtmlGeneratorProvider(Provider<DevelopmentIndexHtmlGenerator> developmentIndexHtmlGeneratorProvider, Provider<ProductionIndexHtmlGenerator> productionIndexHtmlGeneratorProvider, @Named(value="isDevelopmentServer") Boolean isDevelopmentServer) {
        Object indexHtmlGeneratorProvider = isDevelopmentServer != false ? developmentIndexHtmlGeneratorProvider : productionIndexHtmlGeneratorProvider;
        this.indexHtmlGeneratorSupplier = Suppliers.memoize(() -> indexHtmlGeneratorProvider.get());
    }

    public IndexHtmlGenerator get() {
        return this.indexHtmlGeneratorSupplier.get();
    }
}

