/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoException;
import com.mongodb.MongoServerException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.UuidRepresentation;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.graylog2.database.jackson.CustomJacksonCodecRegistry;
import org.graylog2.database.jackson.legacy.LegacyDeleteResult;
import org.graylog2.database.jackson.legacy.LegacyInsertManyResult;
import org.graylog2.database.jackson.legacy.LegacyInsertOneResult;
import org.graylog2.database.jackson.legacy.LegacyUpdateOneResult;
import org.graylog2.database.jackson.legacy.LegacyUpdateResult;
import org.mongojack.DBCursor;
import org.mongojack.JacksonMongoCollection;
import org.mongojack.WriteResult;

@Deprecated
public class JacksonDBCollection<T, K> {
    private final JacksonMongoCollection<T> delegate;
    private final Class<T> valueType;
    private final Class<K> idType;
    private final ObjectMapper objectMapper;
    private final DBCollection dbCollection;

    public static <T, K> JacksonDBCollection<T, K> wrap(DBCollection dbCollection, Class<T> type, Class<K> keyType, ObjectMapper objectMapper) {
        return new JacksonDBCollection<T, K>(dbCollection, type, keyType, objectMapper);
    }

    private JacksonDBCollection(DBCollection dbCollection, Class<T> valueType, Class<K> idType, ObjectMapper objectMapper) {
        MongoDatabase db = dbCollection.getDB().getMongoClient().getDatabase(dbCollection.getDB().getName());
        this.dbCollection = dbCollection;
        JacksonMongoCollection jacksonMongoCollection = JacksonMongoCollection.builder().withObjectMapper(objectMapper).build(db, dbCollection.getName(), valueType, UuidRepresentation.UNSPECIFIED);
        CustomJacksonCodecRegistry jacksonCodecRegistry = new CustomJacksonCodecRegistry(objectMapper, jacksonMongoCollection.getCodecRegistry());
        jacksonCodecRegistry.addCodecForClass(valueType);
        this.delegate = (JacksonMongoCollection)jacksonMongoCollection.withCodecRegistry((CodecRegistry)jacksonCodecRegistry);
        this.valueType = valueType;
        this.idType = idType;
        this.objectMapper = objectMapper;
    }

    public void createIndex(DBObject keys, DBObject options) {
        this.delegate.createIndex((Bson)new BasicDBObject(keys.toMap()), this.toIndexOptions(options));
    }

    public void createIndex(DBObject keys) {
        this.delegate.createIndex((Bson)new BasicDBObject(keys.toMap()));
    }

    public DBCursor<T> find() {
        return new DBCursor<T>(this.delegate, null, () -> this.delegate.find());
    }

    public DBCursor<T> find(Bson filter) {
        return new DBCursor<T>(this.delegate, filter, () -> this.delegate.find(filter));
    }

    public DBCursor<T> find(DBObject dbObject) {
        BasicDBObject filter = new BasicDBObject(dbObject.toMap());
        return new DBCursor<T>(this.delegate, (Bson)filter, () -> this.delegate.find((Bson)filter));
    }

    public T findOneById(K objectId) {
        return (T)this.delegate.findOneById(objectId);
    }

    public T findOne(Bson filter) throws MongoException {
        return (T)this.delegate.findOne(filter);
    }

    public T findOne(DBObject filter) throws MongoException {
        return (T)this.delegate.findOne((Bson)new BasicDBObject(filter.toMap()));
    }

    public T findOne() {
        return (T)this.delegate.findOne();
    }

    public <TResult> Iterable<TResult> distinct(String fieldName, Class<TResult> tResultClass) {
        return this.delegate.distinct(fieldName, tResultClass);
    }

    public long count() {
        return this.delegate.estimatedDocumentCount();
    }

    public long count(Bson filter) {
        return this.delegate.countDocuments(filter);
    }

    public long count(DBObject dbObject) {
        return this.delegate.countDocuments((Bson)new BasicDBObject(dbObject.toMap()));
    }

    public WriteResult<T, K> save(T object) {
        return this.save(object, null);
    }

    public WriteResult<T, K> save(T object, WriteConcern concern) {
        return this.doSave(object, concern);
    }

    private WriteResult<T, K> doSave(T object, WriteConcern concern) {
        JacksonMongoCollection collection = concern == null ? this.delegate : this.delegate.withWriteConcern(concern);
        CollectibleCodec codec = (CollectibleCodec)this.delegate.getCodecRegistry().get(this.valueType);
        BsonValue id = codec.getDocumentId(object);
        try {
            if (id == null || id.isNull()) {
                return new LegacyInsertOneResult(collection, collection.insertOne(object), this.idType);
            }
            Bson idQuery = Filters.eq((String)"_id", (Object)id);
            return new LegacyUpdateOneResult<T, K>(collection, object, collection.replaceOne(idQuery, object, new ReplaceOptions().upsert(true)), this.valueType, this.idType);
        }
        catch (MongoServerException e) {
            throw this.possiblyAsDuplicateKeyError(e);
        }
    }

    public LegacyDeleteResult<T, K> remove(DBObject query) {
        return new LegacyDeleteResult(this.delegate.deleteMany((Bson)new BasicDBObject(query.toMap())));
    }

    public LegacyDeleteResult<T, K> remove(Bson filter) {
        return new LegacyDeleteResult(this.delegate.deleteMany(filter));
    }

    public WriteResult<T, K> remove(Bson filter, WriteConcern concern) {
        JacksonMongoCollection coll = this.delegate.withWriteConcern(concern);
        return new LegacyDeleteResult(coll.deleteMany(filter));
    }

    public LegacyDeleteResult<T, K> removeById(K objectId) {
        return new LegacyDeleteResult(this.delegate.removeById(objectId));
    }

    public WriteResult<T, K> update(Bson filter, T object, boolean upsert, boolean multi) {
        return this.update(filter, object, upsert, multi, this.delegate.getWriteConcern());
    }

    public WriteResult<T, K> update(Bson filter, T object, boolean upsert, boolean multi, @Nullable WriteConcern concern) {
        if (multi) {
            throw new IllegalArgumentException("Multi-update is not supported for object-based updates.");
        }
        JacksonMongoCollection coll = concern == null ? this.delegate : this.delegate.withWriteConcern(concern);
        ReplaceOptions options = new ReplaceOptions().upsert(upsert);
        try {
            return new LegacyUpdateResult(coll.replaceOne(filter, object, options));
        }
        catch (MongoServerException e) {
            throw this.possiblyAsDuplicateKeyError(e);
        }
    }

    public WriteResult<T, K> update(Bson filter, Bson update, boolean upsert, boolean multi) {
        try {
            if (multi) {
                return new LegacyUpdateResult(this.delegate.updateMany(filter, update, new UpdateOptions().upsert(upsert)));
            }
            return new LegacyUpdateResult(this.delegate.updateOne(filter, update, new UpdateOptions().upsert(upsert)));
        }
        catch (MongoServerException e) {
            throw this.possiblyAsDuplicateKeyError(e);
        }
    }

    public WriteResult<T, K> update(Bson query, Bson update) {
        return this.update(query, update, false, false);
    }

    public WriteResult<T, K> update(DBObject query, Bson update) {
        return this.update((Bson)new BasicDBObject(query.toMap()), (T)update);
    }

    public WriteResult<T, K> update(Bson query, T object) {
        return this.update(query, object, false, false);
    }

    public void updateById(K id, Bson update) {
        try {
            this.delegate.updateById(id, update);
        }
        catch (MongoServerException e) {
            throw this.possiblyAsDuplicateKeyError(e);
        }
    }

    public WriteResult<T, K> updateById(K id, T update) {
        try {
            return new LegacyUpdateResult(this.delegate.replaceOneById(id, update));
        }
        catch (MongoServerException e) {
            throw this.possiblyAsDuplicateKeyError(e);
        }
    }

    public WriteResult<T, K> updateMulti(Bson query, Bson update) {
        return this.update(query, update, false, true);
    }

    public WriteResult<T, K> insert(T object) {
        try {
            return new LegacyInsertOneResult<T, K>(this.delegate, this.delegate.insertOne(object), this.idType);
        }
        catch (MongoServerException e) {
            throw this.possiblyAsDuplicateKeyError(e);
        }
    }

    public WriteResult<T, K> insert(List<T> list) {
        try {
            return new LegacyInsertManyResult<T, K>(this.delegate, this.delegate.insertMany(list), this.idType);
        }
        catch (MongoServerException e) {
            throw this.possiblyAsDuplicateKeyError(e);
        }
    }

    public long getCount() {
        return this.delegate.countDocuments();
    }

    public long getCount(Bson filter) {
        return this.delegate.countDocuments(filter);
    }

    public T findAndModify(Bson filter, Bson fields, Bson sort, boolean remove, Bson update, boolean returnNew, boolean upsert) {
        if (remove) {
            throw new IllegalArgumentException("Removing objects is not supported!");
        }
        FindOneAndUpdateOptions options = new FindOneAndUpdateOptions().projection(fields).sort(sort).returnDocument(returnNew ? ReturnDocument.AFTER : ReturnDocument.BEFORE).upsert(upsert);
        try {
            return (T)this.delegate.findOneAndUpdate(filter, update, options);
        }
        catch (MongoServerException e) {
            throw this.possiblyAsDuplicateKeyError(e);
        }
    }

    public T findAndModify(Bson query, Bson update) {
        return (T)this.findAndModify(query, null, null, false, (T)update, false, false);
    }

    public T findAndModify(Bson filter, Bson fields, Bson sort, boolean remove, T object, boolean returnNew, boolean upsert) {
        if (remove) {
            throw new IllegalArgumentException("Removing objects is not supported!");
        }
        FindOneAndReplaceOptions options = new FindOneAndReplaceOptions().projection(fields).sort(sort).returnDocument(returnNew ? ReturnDocument.AFTER : ReturnDocument.BEFORE).upsert(upsert);
        try {
            return (T)this.delegate.findOneAndReplace(filter, object, options);
        }
        catch (MongoServerException e) {
            throw this.possiblyAsDuplicateKeyError(e);
        }
    }

    public T findAndRemove(Bson filter) {
        return (T)this.delegate.findOneAndDelete(filter);
    }

    public void dropIndexes() {
        this.delegate.dropIndexes();
    }

    public void dropIndex(Bson keys) {
        this.delegate.dropIndex(keys);
    }

    public void dropIndex(String name) {
        this.delegate.dropIndex(name);
    }

    public void drop() {
        this.delegate.drop();
    }

    public List<DBObject> getIndexInfo() {
        return (List)this.delegate.listIndexes(DBObject.class).into(new ArrayList());
    }

    public DBCollection getDbCollection() {
        return this.dbCollection;
    }

    private IndexOptions toIndexOptions(DBObject options) {
        return ((IndexOptionDto)this.objectMapper.convertValue((Object)options.toMap(), IndexOptionDto.class)).toIndexOptions();
    }

    private MongoException possiblyAsDuplicateKeyError(MongoServerException e) {
        if (ErrorCategory.fromErrorCode((int)e.getCode()) == ErrorCategory.DUPLICATE_KEY) {
            return new DuplicateKeyException(new BsonDocument("err", (BsonValue)new BsonString(e.getMessage())), e.getServerAddress(), WriteConcernResult.acknowledged((int)0, (boolean)false, null));
        }
        return e;
    }

    record IndexOptionDto(@JsonProperty(value="unique") Optional<Boolean> unique, @JsonProperty(value="name") Optional<String> name, @JsonProperty(value="expireAfterSeconds") Optional<Long> expireAfterSeconds, @JsonProperty(value="sparse") Optional<Boolean> sparse, @JsonProperty(value="collation") Optional<CollationDto> collationDto) {
        public IndexOptions toIndexOptions() {
            IndexOptions io = new IndexOptions();
            this.unique.ifPresent(arg_0 -> ((IndexOptions)io).unique(arg_0));
            this.name.ifPresent(arg_0 -> ((IndexOptions)io).name(arg_0));
            this.expireAfterSeconds.ifPresent(seconds -> io.expireAfter(seconds, TimeUnit.SECONDS));
            this.sparse.ifPresent(arg_0 -> ((IndexOptions)io).sparse(arg_0));
            this.collationDto.ifPresent(collation -> io.collation(collation.toCollation()));
            return io;
        }
    }

    record CollationDto(@JsonProperty(value="locale") Optional<String> locale, @JsonProperty(value="strength") Optional<Integer> strength) {
        public Collation toCollation() {
            Collation.Builder builder = Collation.builder();
            this.locale.ifPresent(arg_0 -> ((Collation.Builder)builder).locale(arg_0));
            this.strength.ifPresent(s -> builder.collationStrength(CollationStrength.fromInt((int)s)));
            return builder.build();
        }
    }
}

