/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.fields.providers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.template.VariableDescription;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.graylog.events.event.EventWithContext;
import org.graylog.events.fields.FieldValue;
import org.graylog.events.fields.providers.AbstractFieldValueProvider;
import org.graylog.events.fields.providers.AutoValue_TemplateFieldValueProvider_Config;
import org.graylog.events.fields.providers.FieldValueProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateFieldValueProvider
extends AbstractFieldValueProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateFieldValueProvider.class);
    private final Config config;
    private final Engine templateEngine;

    @Inject
    public TemplateFieldValueProvider(@Assisted FieldValueProvider.Config config, Engine templateEngine) {
        super(config);
        this.config = (Config)config;
        this.templateEngine = templateEngine;
    }

    @Override
    protected FieldValue doGet(String fieldName, EventWithContext eventWithContext) {
        ImmutableMap.Builder dataModelBuilder = ImmutableMap.builder();
        if (eventWithContext.messageContext().isPresent()) {
            dataModelBuilder.put((Object)"source", eventWithContext.messageContext().get().getFields());
        } else if (eventWithContext.eventContext().isPresent()) {
            dataModelBuilder.put((Object)"source", eventWithContext.eventContext().get().toDto().fields());
        }
        ImmutableMap dataModel = dataModelBuilder.build();
        if (!this.isValidTemplate(this.config.template(), (Map<String, Object>)dataModel)) {
            return FieldValue.error();
        }
        try {
            return FieldValue.string(this.templateEngine.transform(this.config.template(), (Map)dataModel));
        }
        catch (Exception e) {
            LOG.error("Couldn't render field template \"{}\"", (Object)this.config.template(), (Object)e);
            return FieldValue.error();
        }
    }

    private boolean isValidTemplate(String template, Map<String, Object> dataModel) {
        int endTokenCount;
        int startTokenCount;
        if (template.contains(this.templateEngine.getExprStartToken()) && (startTokenCount = StringUtils.countMatches((CharSequence)template, (CharSequence)this.templateEngine.getExprStartToken())) != (endTokenCount = StringUtils.countMatches((CharSequence)template, (CharSequence)this.templateEngine.getExprEndToken()))) {
            LOG.error("Syntax error in template \"{}\" - uneven number of start and end tokens (\"${\" and \"}\")", (Object)template);
            return false;
        }
        if (this.config.requireValues()) {
            boolean error = false;
            for (VariableDescription variable : this.templateEngine.getUsedVariableDescriptions(template)) {
                String tmpl = String.join((CharSequence)"", this.templateEngine.getExprStartToken(), variable.name, this.templateEngine.getExprEndToken());
                String result = this.templateEngine.transform(tmpl, dataModel);
                if (variable.context != VariableDescription.Context.TEXT || !Strings.isNullOrEmpty((String)result)) continue;
                LOG.error("No value found for variable \"{}\" in template \"{}\"", (Object)variable.name, (Object)template);
                error = true;
            }
            if (error) {
                return false;
            }
        }
        return true;
    }

    @JsonTypeName(value="template-v1")
    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class Config
    implements FieldValueProvider.Config {
        public static final String TYPE_NAME = "template-v1";
        private static final String FIELD_TEMPLATE = "template";
        private static final String FIELD_REQUIRE_VALUES = "require_values";

        @JsonProperty(value="template")
        public abstract String template();

        @JsonProperty(value="require_values")
        public abstract boolean requireValues();

        public static Builder builder() {
            return Builder.create();
        }

        public abstract Builder toBuilder();

        @AutoValue.Builder
        public static abstract class Builder
        implements FieldValueProvider.Config.Builder<Builder> {
            @JsonCreator
            public static Builder create() {
                return new AutoValue_TemplateFieldValueProvider_Config.Builder().type(Config.TYPE_NAME).requireValues(false);
            }

            @JsonProperty(value="template")
            public abstract Builder template(String var1);

            @JsonProperty(value="require_values")
            public abstract Builder requireValues(boolean var1);

            public abstract Config build();
        }
    }

    public static interface Factory
    extends AbstractFieldValueProvider.Factory<TemplateFieldValueProvider> {
        @Override
        public TemplateFieldValueProvider create(FieldValueProvider.Config var1);
    }
}

