/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.legacy;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.graylog.events.legacy.LegacyAlarmCallbackEventNotificationConfig;
import org.graylog.events.legacy.LegacyAlarmCallbackSender;
import org.graylog.events.notifications.EventNotification;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationService;
import org.graylog.events.notifications.PermanentEventNotificationException;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog2.plugin.MessageSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyAlarmCallbackEventNotification
implements EventNotification {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyAlarmCallbackEventNotification.class);
    private final EventNotificationService notificationCallbackService;
    private final LegacyAlarmCallbackSender alarmCallbackSender;

    @Inject
    public LegacyAlarmCallbackEventNotification(EventNotificationService notificationCallbackService, LegacyAlarmCallbackSender alarmCallbackSender) {
        this.notificationCallbackService = notificationCallbackService;
        this.alarmCallbackSender = alarmCallbackSender;
    }

    @Override
    public void execute(EventNotificationContext ctx) throws PermanentEventNotificationException {
        LegacyAlarmCallbackEventNotificationConfig config = (LegacyAlarmCallbackEventNotificationConfig)ctx.notificationConfig();
        ImmutableList<MessageSummary> messagesForEvent = this.notificationCallbackService.getBacklogForEvent(ctx);
        Optional<EventDefinitionDto> optionalEventDefinition = ctx.eventDefinition();
        if (!optionalEventDefinition.isPresent()) {
            String msg = String.format(Locale.ROOT, "Unable to find definition for event <%s>", ctx.event().id());
            LOG.error(msg);
            throw new PermanentEventNotificationException(msg);
        }
        try {
            this.alarmCallbackSender.send(config, optionalEventDefinition.get(), ctx.event(), (List<MessageSummary>)messagesForEvent);
        }
        catch (Exception e) {
            throw new PermanentEventNotificationException("Couldn't send legacy notification - legacy notifications cannot be retried!", e);
        }
    }

    public static interface Factory
    extends EventNotification.Factory {
        public LegacyAlarmCallbackEventNotification create();
    }
}

